/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant;

import com.google.gson.Gson;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.AbstractComponent;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.CChannel;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.HaID;
import org.eclipse.smarthome.binding.mqtt.generic.internal.generic.ChannelStateUpdateListener;
import org.eclipse.smarthome.binding.mqtt.generic.internal.values.RollershutterValue;
import org.eclipse.smarthome.core.thing.ThingUID;

@NonNullByDefault
public class ComponentCover
extends AbstractComponent {
    public static final String switchChannelID = "cover";
    protected Config config = new Config();

    public ComponentCover(ThingUID thing, HaID haID, String configJSON, @Nullable ChannelStateUpdateListener updateListener, Gson gson) {
        super(thing, haID, configJSON, gson);
        this.config = (Config)gson.fromJson(configJSON, Config.class);
        RollershutterValue value = new RollershutterValue(this.config.payload_open, this.config.payload_close, this.config.payload_stop);
        this.channels.put(switchChannelID, new CChannel(this, switchChannelID, value, this.config.state_topic, this.config.command_topic, this.config.name, "", updateListener));
    }

    @Override
    public String name() {
        return this.config.name;
    }

    static class Config {
        protected String name = "MQTT fan";
        protected String icon = "";
        protected int qos = 1;
        protected boolean retain = true;
        protected @Nullable String state_value_template;
        protected @Nullable String unique_id;
        protected @Nullable String state_topic;
        protected @Nullable String command_topic;
        protected String payload_open = "OPEN";
        protected String payload_close = "CLOSE";
        protected String payload_stop = "STOP";

        Config() {
        }
    }
}

