/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant;

import com.google.gson.Gson;
import java.lang.ref.WeakReference;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.AbstractComponent;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.CFactory;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.HaID;
import org.eclipse.smarthome.binding.mqtt.generic.internal.generic.ChannelStateUpdateListener;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.io.transport.mqtt.MqttBrokerConnection;
import org.eclipse.smarthome.io.transport.mqtt.MqttMessageSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class DiscoverComponents
implements MqttMessageSubscriber {
    private final Logger logger = LoggerFactory.getLogger(DiscoverComponents.class);
    private final ThingUID thingUID;
    private final ScheduledExecutorService scheduler;
    private final @Nullable ChannelStateUpdateListener updateListener;
    protected final CompletableFuture<@Nullable Void> discoverFinishedFuture = new CompletableFuture();
    private final Gson gson;
    private @Nullable ScheduledFuture<?> stopDiscoveryFuture;
    private WeakReference<@Nullable MqttBrokerConnection> connectionRef = new WeakReference<Object>(null);
    @NonNullByDefault(value={})
    protected ComponentDiscovered discoveredListener;
    private int discoverTime;
    private String topicWithNode = "";
    private String topic = "";

    public DiscoverComponents(ThingUID thingUID, ScheduledExecutorService scheduler, @Nullable ChannelStateUpdateListener channelStateUpdateListener, Gson gson) {
        this.thingUID = thingUID;
        this.scheduler = scheduler;
        this.updateListener = channelStateUpdateListener;
        this.gson = gson;
    }

    public void processMessage(String topic, byte[] payload) {
        if (!topic.endsWith("/config")) {
            return;
        }
        HaID haID = new HaID(topic);
        String config = new String(payload);
        AbstractComponent component = CFactory.createComponent(this.thingUID, haID, config, this.updateListener, this.gson);
        if (component != null) {
            this.logger.trace("Found HomeAssistant thing {} component {}", (Object)haID.objectID, (Object)haID.component);
            if (this.discoveredListener != null) {
                this.discoveredListener.componentDiscovered(haID, component);
            }
        } else {
            this.logger.debug("Configuration of HomeAssistant thing {} invalid: {}", (Object)haID.objectID, (Object)config);
        }
    }

    public CompletableFuture<@Nullable Void> startDiscovery(MqttBrokerConnection connection, int discoverTime, HaID topicDescription, ComponentDiscovered componentsDiscoveredListener) {
        this.topicWithNode = String.valueOf(topicDescription.baseTopic) + "/+/+/" + topicDescription.objectID + "/config";
        this.topic = String.valueOf(topicDescription.baseTopic) + "/+/" + topicDescription.objectID + "/config";
        this.discoverTime = discoverTime;
        this.discoveredListener = componentsDiscoveredListener;
        this.connectionRef = new WeakReference<MqttBrokerConnection>(connection);
        ((CompletableFuture)CompletableFuture.allOf(connection.subscribe(this.topic, (MqttMessageSubscriber)this), connection.subscribe(this.topicWithNode, (MqttMessageSubscriber)this)).thenRun(this::subscribeSuccess)).exceptionally(this::subscribeFail);
        return this.discoverFinishedFuture;
    }

    private void subscribeSuccess() {
        MqttBrokerConnection connection = (MqttBrokerConnection)this.connectionRef.get();
        if (connection != null && this.discoverTime > 0) {
            this.stopDiscoveryFuture = this.scheduler.schedule(() -> {
                this.stopDiscoveryFuture = null;
                connection.unsubscribe(this.topicWithNode, (MqttMessageSubscriber)this);
                connection.unsubscribe(this.topic, (MqttMessageSubscriber)this);
                this.discoveredListener = null;
                this.discoverFinishedFuture.complete(null);
            }, (long)this.discoverTime, TimeUnit.MILLISECONDS);
        } else {
            this.discoverFinishedFuture.complete(null);
        }
    }

    private @Nullable Void subscribeFail(Throwable e) {
        ScheduledFuture<?> scheduledFuture = this.stopDiscoveryFuture;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
            this.stopDiscoveryFuture = null;
        }
        this.discoveredListener = null;
        MqttBrokerConnection connection = (MqttBrokerConnection)this.connectionRef.get();
        if (connection != null) {
            connection.unsubscribe(this.topicWithNode, (MqttMessageSubscriber)this);
            connection.unsubscribe(this.topic, (MqttMessageSubscriber)this);
            this.connectionRef.clear();
        }
        this.discoverFinishedFuture.completeExceptionally(e);
        return null;
    }

    public void stopDiscovery() {
        this.subscribeFail(new Throwable("Stopped"));
    }

    public static interface ComponentDiscovered {
        public void componentDiscovered(HaID var1, AbstractComponent var2);
    }
}

