/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homie300;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homie300.DeviceAttributes;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homie300.DeviceCallback;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homie300.Node;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homie300.NodeAttributes;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homie300.Property;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homie300.PropertyAttributes;
import org.eclipse.smarthome.binding.mqtt.generic.internal.handler.HomieThingHandler;
import org.eclipse.smarthome.binding.mqtt.generic.internal.mapping.AbstractMqttAttributeClass;
import org.eclipse.smarthome.binding.mqtt.generic.internal.tools.ChildMap;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.io.transport.mqtt.MqttBrokerConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class Device
implements AbstractMqttAttributeClass.AttributeChanged {
    private final Logger logger = LoggerFactory.getLogger(Device.class);
    public final DeviceAttributes attributes;
    public final ChildMap<Node> nodes;
    public final ThingUID thingUID;
    private final DeviceCallback callback;
    private String topic = "";
    public String deviceID = "";
    private boolean initialized = false;

    public Device(ThingUID thingUID, DeviceCallback callback, DeviceAttributes attributes) {
        this.thingUID = thingUID;
        this.callback = callback;
        this.attributes = attributes;
        this.nodes = new ChildMap();
    }

    public Device(ThingUID thingUID, DeviceCallback callback, DeviceAttributes attributes, ChildMap<Node> nodes) {
        this.thingUID = thingUID;
        this.callback = callback;
        this.attributes = attributes;
        this.nodes = nodes;
    }

    public CompletableFuture<@Nullable Void> subscribe(MqttBrokerConnection connection, ScheduledExecutorService scheduler, int timeout) {
        if (this.topic.isEmpty()) {
            throw new IllegalStateException("You must call initialize()!");
        }
        return ((CompletableFuture)this.attributes.subscribeAndReceive(connection, scheduler, this.topic, this, timeout).thenCompose(b -> this.attributesReceived(connection, scheduler, timeout))).whenComplete((r, e) -> {
            this.initialized = true;
        });
    }

    public CompletableFuture<@Nullable Void> attributesReceived(MqttBrokerConnection connection, ScheduledExecutorService scheduler, int timeout) {
        this.callback.readyStateChanged(this.attributes.state);
        return this.applyNodes(connection, scheduler, timeout);
    }

    public CompletableFuture<@Nullable Void> startChannels(MqttBrokerConnection connection, ScheduledExecutorService scheduler, int timeout, HomieThingHandler handler) {
        if (!this.isInitialized() || this.deviceID.isEmpty()) {
            CompletableFuture<@Nullable Void> c = new CompletableFuture<Void>();
            c.completeExceptionally(new Exception("Homie Device Tree not inialized yet."));
            return c;
        }
        return CompletableFuture.allOf((CompletableFuture[])this.nodes.stream().flatMap(node -> node.properties.stream()).map(p -> p.startChannel(connection, scheduler, timeout)).toArray(CompletableFuture[]::new));
    }

    public @Nullable Property getProperty(ChannelUID channelUID) {
        Node node = this.nodes.get(channelUID.getGroupId());
        if (node == null) {
            return null;
        }
        return node.properties.get(channelUID.getIdWithoutGroup());
    }

    public CompletableFuture<@Nullable Void> stop() {
        return this.attributes.unsubscribe().thenCompose(b -> CompletableFuture.allOf((CompletableFuture[])this.nodes.stream().map(n -> n.stop()).toArray(CompletableFuture[]::new)));
    }

    public ChildMap<Node> nodes() {
        return this.nodes;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize(String baseTopic, String deviceID, List<Channel> channels) {
        this.topic = String.valueOf(baseTopic) + "/" + deviceID;
        this.deviceID = deviceID;
        this.nodes.clear();
        for (Channel channel : channels) {
            String nodeID = channel.getUID().getGroupId();
            String propertyID = channel.getUID().getIdWithoutGroup();
            if (nodeID == null) continue;
            Node node = this.nodes.get(nodeID);
            if (node == null) {
                node = this.createNode(nodeID);
                node.nodeRestoredFromConfig();
                this.nodes.put(nodeID, node);
            }
            Property property = node.createProperty(propertyID, (PropertyAttributes)channel.getConfiguration().as(PropertyAttributes.class));
            property.createChannelFromAttribute();
            node.properties.put(propertyID, property);
        }
    }

    public Node createNode(String nodeID) {
        return new Node(this.topic, nodeID, this.thingUID, this.callback, new NodeAttributes());
    }

    public Node createNode(String nodeID, NodeAttributes attributes) {
        return new Node(this.topic, nodeID, this.thingUID, this.callback, attributes);
    }

    protected void notifyNodeRemoved(Node node) {
        node.stop();
        node.properties.stream().forEach(property -> node.notifyPropertyRemoved((Property)property));
        this.callback.nodeRemoved(node);
    }

    CompletableFuture<@Nullable Void> applyNodes(MqttBrokerConnection connection, ScheduledExecutorService scheduler, int timeout) {
        return this.nodes.apply(this.attributes.nodes, node -> node.subscribe(connection, scheduler, timeout), this::createNode, this::notifyNodeRemoved).exceptionally(e -> {
            this.logger.warn("Could not subscribe", e);
            return null;
        });
    }

    @Override
    public void attributeChanged(String name, Object value, MqttBrokerConnection connection, ScheduledExecutorService scheduler, boolean allMandatoryFieldsReceived) {
        block12: {
            block11: {
                if (!this.initialized || !allMandatoryFieldsReceived) {
                    return;
                }
                if (this.attributes.isComplete()) break block11;
                this.attributesReceived(connection, scheduler, 500);
                break block12;
            }
            switch (name) {
                case "state": {
                    this.callback.readyStateChanged(this.attributes.state);
                    return;
                }
                case "nodes": {
                    this.applyNodes(connection, scheduler, 500);
                    return;
                }
            }
        }
    }
}

