/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homie300;

import java.math.BigDecimal;
import java.math.MathContext;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homie300.DeviceCallback;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homie300.Node;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homie300.PropertyAttributes;
import org.eclipse.smarthome.binding.mqtt.generic.internal.generic.ChannelConfigBuilder;
import org.eclipse.smarthome.binding.mqtt.generic.internal.generic.ChannelState;
import org.eclipse.smarthome.binding.mqtt.generic.internal.mapping.AbstractMqttAttributeClass;
import org.eclipse.smarthome.binding.mqtt.generic.internal.values.ColorValue;
import org.eclipse.smarthome.binding.mqtt.generic.internal.values.NumberValue;
import org.eclipse.smarthome.binding.mqtt.generic.internal.values.OnOffValue;
import org.eclipse.smarthome.binding.mqtt.generic.internal.values.TextValue;
import org.eclipse.smarthome.binding.mqtt.generic.internal.values.Value;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.DefaultSystemChannelTypeProvider;
import org.eclipse.smarthome.core.thing.binding.builder.ChannelBuilder;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.ChannelTypeBuilder;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;
import org.eclipse.smarthome.core.thing.type.StateChannelTypeBuilder;
import org.eclipse.smarthome.core.thing.type.TriggerChannelTypeBuilder;
import org.eclipse.smarthome.io.transport.mqtt.MqttBrokerConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class Property
implements AbstractMqttAttributeClass.AttributeChanged {
    private final Logger logger = LoggerFactory.getLogger(Property.class);
    public final PropertyAttributes attributes;
    public final Node parentNode;
    public final String propertyID;
    protected @Nullable ChannelState channelState;
    public final ChannelUID channelUID;
    public final ChannelTypeUID channelTypeUID;
    private ChannelType type;
    private Channel channel;
    private final String topic;
    private final DeviceCallback callback;
    protected boolean initialized = false;

    public Property(String topic, Node node, String propertyID, DeviceCallback callback, PropertyAttributes attributes) {
        this.callback = callback;
        this.attributes = attributes;
        this.topic = String.valueOf(topic) + "/" + propertyID;
        this.parentNode = node;
        this.propertyID = propertyID;
        this.channelUID = new ChannelUID(node.uid(), propertyID);
        this.channelTypeUID = new ChannelTypeUID("mqtt", this.topic.replace('/', '_'));
        this.type = ChannelTypeBuilder.trigger((ChannelTypeUID)this.channelTypeUID, (String)"dummy").build();
        this.channel = ChannelBuilder.create((ChannelUID)this.channelUID, (String)"dummy").build();
    }

    public CompletableFuture<@Nullable Void> subscribe(MqttBrokerConnection connection, ScheduledExecutorService scheduler, int timeout) {
        return ((CompletableFuture)this.attributes.subscribeAndReceive(connection, scheduler, this.topic, this, timeout).thenRun(this::attributesReceived)).whenComplete((r, e) -> {
            this.initialized = true;
        });
    }

    private @Nullable BigDecimal convertFromString(String value) {
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException numberFormatException) {
            this.logger.debug("Cannot convert {} to a number", (Object)value);
            return null;
        }
    }

    public void attributesReceived() {
        this.createChannelFromAttribute();
        this.callback.propertyAddedOrChanged(this);
    }

    private ChannelType createChannelType(PropertyAttributes attributes, ChannelState channelState) {
        if (attributes.retained) {
            return ((StateChannelTypeBuilder)ChannelTypeBuilder.state((ChannelTypeUID)this.channelTypeUID, (String)attributes.name, (String)channelState.getItemType()).withConfigDescriptionURI(URI.create("mqtt:homie_channel"))).withStateDescription(channelState.getCache().createStateDescription(attributes.unit, !attributes.settable)).build();
        }
        if (attributes.datatype.equals((Object)PropertyAttributes.DataTypeEnum.enum_)) {
            if (attributes.format.contains("PRESSED") && attributes.format.contains("RELEASED")) {
                return DefaultSystemChannelTypeProvider.SYSTEM_RAWBUTTON;
            }
            if (attributes.format.contains("SHORT_PRESSED") && attributes.format.contains("LONG_PRESSED") && attributes.format.contains("DOUBLE_PRESSED")) {
                return DefaultSystemChannelTypeProvider.SYSTEM_BUTTON;
            }
            if (attributes.format.contains("DIR1_PRESSED") && attributes.format.contains("DIR1_RELEASED") && attributes.format.contains("DIR2_PRESSED") && attributes.format.contains("DIR2_RELEASED")) {
                return DefaultSystemChannelTypeProvider.SYSTEM_RAWROCKER;
            }
        }
        return ((TriggerChannelTypeBuilder)ChannelTypeBuilder.trigger((ChannelTypeUID)this.channelTypeUID, (String)attributes.name).withConfigDescriptionURI(URI.create("mqtt:homie_channel"))).build();
    }

    public void createChannelFromAttribute() {
        ChannelType type;
        ChannelState channelState;
        Value value;
        String commandTopic = String.valueOf(this.topic) + "/set";
        String stateTopic = this.topic;
        Boolean isDecimal = null;
        switch (this.attributes.datatype) {
            case boolean_: {
                value = new OnOffValue("true", "false");
                break;
            }
            case color_: {
                value = new ColorValue(this.attributes.format.contains("rgb"), null, null, 100);
                break;
            }
            case enum_: {
                String[] enumValues = this.attributes.format.split(",");
                value = new TextValue(enumValues);
                break;
            }
            case integer_: 
            case float_: {
                BigDecimal step;
                BigDecimal max;
                isDecimal = this.attributes.datatype == PropertyAttributes.DataTypeEnum.float_;
                String[] s = this.attributes.format.split("\\:");
                BigDecimal min = s.length == 2 ? this.convertFromString(s[0]) : null;
                BigDecimal bigDecimal = max = s.length == 2 ? this.convertFromString(s[1]) : null;
                BigDecimal bigDecimal2 = min != null && max != null ? max.subtract(min).divide(new BigDecimal(100.0), new MathContext(isDecimal != false ? 2 : 0)) : (step = null);
                if (step != null && !isDecimal.booleanValue() && step.intValue() <= 0) {
                    step = new BigDecimal(1);
                }
                value = new NumberValue(min, max, step);
                break;
            }
            default: {
                value = new TextValue();
            }
        }
        ChannelConfigBuilder b = ChannelConfigBuilder.create().makeTrigger(!this.attributes.retained).withStateTopic(stateTopic);
        if (isDecimal != null && !isDecimal.booleanValue()) {
            b = b.withFormatter("%d");
        }
        if (this.attributes.settable) {
            b = b.withCommandTopic(commandTopic);
        }
        this.channelState = channelState = new ChannelState(b.build(), this.channelUID, value, this.callback);
        this.type = type = this.createChannelType(this.attributes, channelState);
        this.channel = ChannelBuilder.create((ChannelUID)this.channelUID, (String)type.getItemType()).withType(type.getUID()).withKind(type.getKind()).withLabel(this.attributes.name).withConfiguration(new Configuration(this.attributes.asMap())).build();
    }

    public CompletableFuture<@Nullable Void> stop() {
        ChannelState channelState = this.channelState;
        if (channelState != null) {
            return channelState.stop().thenCompose(b -> this.attributes.unsubscribe());
        }
        return this.attributes.unsubscribe();
    }

    public @Nullable ChannelState getChannelState() {
        return this.channelState;
    }

    public CompletableFuture<@Nullable Void> startChannel(MqttBrokerConnection connection, ScheduledExecutorService scheduler, int timeout) {
        ChannelState channelState = this.channelState;
        if (channelState == null) {
            CompletableFuture<@Nullable Void> f = new CompletableFuture<Void>();
            f.completeExceptionally(new IllegalStateException("Attributes not yet received!"));
            return f;
        }
        return channelState.start(connection, scheduler, timeout);
    }

    public ChannelType getType() {
        return this.type;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public String toString() {
        return this.channelUID.toString();
    }

    @Override
    public void attributeChanged(String name, Object value, MqttBrokerConnection connection, ScheduledExecutorService scheduler, boolean allMandatoryFieldsReceived) {
        if (!this.initialized || !allMandatoryFieldsReceived) {
            return;
        }
        this.attributesReceived();
    }
}

