/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.generic;

import java.lang.ref.WeakReference;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.generic.internal.generic.TransformationServiceProvider;
import org.eclipse.smarthome.core.transform.TransformationException;
import org.eclipse.smarthome.core.transform.TransformationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class ChannelStateTransformation {
    private final Logger logger = LoggerFactory.getLogger(ChannelStateTransformation.class);
    private final TransformationServiceProvider provider;
    private WeakReference<@Nullable TransformationService> transformationService = new WeakReference<Object>(null);
    final String pattern;
    final String serviceName;

    public ChannelStateTransformation(String pattern, TransformationServiceProvider provider) {
        this.provider = provider;
        int index = pattern.indexOf(58);
        if (index == -1) {
            throw new IllegalArgumentException("The transformation pattern must consist of the type and the pattern separated by a colon");
        }
        String type = pattern.substring(0, index).toUpperCase();
        this.pattern = pattern.substring(index + 1);
        this.serviceName = type;
    }

    protected String processValue(String value) {
        TransformationService transformationService = (TransformationService)this.transformationService.get();
        if (transformationService == null) {
            transformationService = this.provider.getTransformationService(this.serviceName);
            if (transformationService == null) {
                this.logger.warn("Transformation service {} for pattern {} not found!", (Object)this.serviceName, (Object)this.pattern);
                return value;
            }
            this.transformationService = new WeakReference<TransformationService>(transformationService);
        }
        String temp = null;
        try {
            temp = transformationService.transform(this.pattern, value);
        }
        catch (TransformationException e) {
            this.logger.warn("Executing the {}-transformation failed: {}", (Object)this.serviceName, (Object)e.getMessage());
        }
        return temp != null ? temp : value;
    }
}

