/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.values;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.generic.internal.values.Value;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.IncreaseDecreaseType;
import org.eclipse.smarthome.core.library.types.UpDownType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.StateDescription;
import org.eclipse.smarthome.core.types.UnDefType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class NumberValue
extends Value {
    private final Logger logger = LoggerFactory.getLogger(NumberValue.class);
    private final @Nullable BigDecimal min;
    private final @Nullable BigDecimal max;
    private final BigDecimal step;

    public NumberValue(@Nullable BigDecimal min, @Nullable BigDecimal max, @Nullable BigDecimal step) {
        super("Number", Stream.of(DecimalType.class, IncreaseDecreaseType.class, UpDownType.class).collect(Collectors.toList()));
        this.min = min;
        this.max = max;
        this.step = step == null ? new BigDecimal(1.0) : step;
    }

    protected boolean checkConditions(BigDecimal newValue, DecimalType oldvalue) {
        if (this.min != null && newValue.compareTo(this.min) == -1) {
            this.logger.trace("Number not accepted as it is below the configured minimum");
            return false;
        }
        if (this.max != null && newValue.compareTo(this.max) == 1) {
            this.logger.trace("Number not accepted as it is above the configured maximum");
            return false;
        }
        return true;
    }

    @Override
    public void update(Command command) throws IllegalArgumentException {
        DecimalType oldvalue;
        DecimalType decimalType = oldvalue = this.state == UnDefType.UNDEF ? new DecimalType() : (DecimalType)this.state;
        if (command instanceof DecimalType) {
            if (!this.checkConditions(((DecimalType)command).toBigDecimal(), oldvalue)) {
                return;
            }
            this.state = (DecimalType)command;
        } else if (command instanceof IncreaseDecreaseType || command instanceof UpDownType) {
            BigDecimal newValue = command == IncreaseDecreaseType.INCREASE || command == UpDownType.UP ? oldvalue.toBigDecimal().add(this.step) : oldvalue.toBigDecimal().subtract(this.step);
            if (!this.checkConditions(newValue, oldvalue)) {
                return;
            }
            this.state = new DecimalType(newValue);
        } else {
            BigDecimal newValue = new BigDecimal(command.toString());
            if (!this.checkConditions(newValue, oldvalue)) {
                return;
            }
            this.state = new DecimalType(newValue);
        }
    }

    @Override
    public StateDescription createStateDescription(String unit, boolean readOnly) {
        return new StateDescription(this.min, this.max, this.step, "%s " + unit.replace("%", "%%"), readOnly, Collections.emptyList());
    }
}

