/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.handler;

import java.util.concurrent.CompletableFuture;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.mqtt.handler.AbstractBrokerHandler;
import org.eclipse.smarthome.binding.mqtt.handler.PublishTriggerChannelConfig;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.io.transport.mqtt.MqttBrokerConnection;
import org.eclipse.smarthome.io.transport.mqtt.MqttMessageSubscriber;

@NonNullByDefault
public class PublishTriggerChannel
implements MqttMessageSubscriber {
    private final MqttBrokerConnection connection;
    private final PublishTriggerChannelConfig config;
    private final ChannelUID uid;
    private final AbstractBrokerHandler handler;

    PublishTriggerChannel(PublishTriggerChannelConfig config, ChannelUID uid, MqttBrokerConnection connection, AbstractBrokerHandler handler) {
        this.config = config;
        this.uid = uid;
        this.connection = connection;
        this.handler = handler;
    }

    CompletableFuture<Boolean> start() {
        return this.stop().thenCompose(b -> this.connection.subscribe(this.config.stateTopic, (MqttMessageSubscriber)this));
    }

    public void processMessage(String topic, byte[] payload) {
        String value = new String(payload);
        String expectedPayload = this.config.payload;
        if (expectedPayload != null && !value.equals(expectedPayload)) {
            return;
        }
        if (this.config.separator.isEmpty()) {
            this.handler.triggerChannel(this.uid, value);
        } else {
            this.handler.triggerChannel(this.uid, String.valueOf(topic) + this.config.separator + value);
        }
    }

    public CompletableFuture<Boolean> stop() {
        return this.connection.unsubscribe(this.config.stateTopic, (MqttMessageSubscriber)this);
    }
}

