/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.handler;

import java.util.HashMap;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.handler.AbstractBrokerHandler;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.io.transport.mqtt.MqttBrokerConnection;
import org.eclipse.smarthome.io.transport.mqtt.MqttConnectionObserver;
import org.eclipse.smarthome.io.transport.mqtt.MqttConnectionState;
import org.eclipse.smarthome.io.transport.mqtt.MqttService;
import org.eclipse.smarthome.io.transport.mqtt.MqttServiceObserver;
import org.eclipse.smarthome.io.transport.mqtt.MqttWillAndTestament;
import org.eclipse.smarthome.io.transport.mqtt.reconnect.PeriodicReconnectStrategy;

@NonNullByDefault
public class SystemBrokerHandler
extends AbstractBrokerHandler
implements MqttServiceObserver {
    public static final String PROPERTY_URL = "url";
    public static final String PROPERTY_USERNAME = "username";
    public static final String PROPERTY_PASSWORD = "password";
    public static final String PROPERTY_QOS = "qos";
    public static final String PROPERTY_RETAIN = "retain";
    public static final String PROPERTY_LAST_WILL = "lastwill";
    public static final String PROPERTY_RECONNECT_TIME = "reconnect_time_ms";
    public static final String PROPERTY_KEEP_ALIVE_TIME = "keep_alive_time_ms";
    public static final String PROPERTY_CONNECT_TIMEOUT = "connect_timeout_ms";
    protected final MqttService service;
    protected String brokerID = "";

    public SystemBrokerHandler(Bridge thing, MqttService service) {
        super(thing);
        this.service = service;
    }

    @Override
    public void connectionStateChanged(MqttConnectionState state, @Nullable Throwable error) {
        PeriodicReconnectStrategy strategy;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(PROPERTY_URL, String.valueOf(this.connection.getHost()) + ":" + String.valueOf(this.connection.getPort()));
        String username = this.connection.getUser();
        String password = this.connection.getPassword();
        if (username != null && password != null) {
            properties.put(PROPERTY_USERNAME, username);
            properties.put(PROPERTY_PASSWORD, password);
        }
        properties.put(PROPERTY_QOS, String.valueOf(this.connection.getQos()));
        properties.put(PROPERTY_RETAIN, String.valueOf(this.connection.isRetain()));
        MqttWillAndTestament lastWill = this.connection.getLastWill();
        if (lastWill != null) {
            properties.put(PROPERTY_LAST_WILL, lastWill.toString());
        } else {
            properties.put(PROPERTY_LAST_WILL, "");
        }
        if (this.connection.getReconnectStrategy() instanceof PeriodicReconnectStrategy && (strategy = (PeriodicReconnectStrategy)this.connection.getReconnectStrategy()) != null) {
            properties.put(PROPERTY_RECONNECT_TIME, String.valueOf(strategy.getReconnectFrequency()));
        }
        properties.put(PROPERTY_KEEP_ALIVE_TIME, String.valueOf(this.connection.getKeepAliveInterval()));
        this.updateProperties(properties);
        super.connectionStateChanged(state, error);
    }

    public void brokerAdded(String connectionName, MqttBrokerConnection addedConnection) {
        if (!connectionName.equals(this.brokerID) || this.connection == addedConnection) {
            return;
        }
        this.connection = addedConnection;
        super.initialize();
    }

    public void brokerRemoved(String connectionName, MqttBrokerConnection removedConnection) {
        MqttBrokerConnection connection = this.connection;
        if (removedConnection == connection) {
            connection.removeConnectionObserver((MqttConnectionObserver)this);
            this.connection = null;
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "@text/offline.sharedremoved");
            return;
        }
    }

    @Override
    public void initialize() {
        this.brokerID = this.getThing().getConfiguration().get("brokerid").toString();
        this.service.addBrokersListener((MqttServiceObserver)this);
        this.connection = this.service.getBrokerConnection(this.brokerID);
        if (this.connection == null) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "@text/offline.notextualconfig [\"" + this.brokerID + "\"");
            return;
        }
        super.initialize();
    }

    @Override
    public void dispose() {
        this.service.removeBrokersListener((MqttServiceObserver)this);
        super.dispose();
    }
}

