/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.mqtt.discovery.MQTTTopicDiscoveryParticipant;
import org.eclipse.smarthome.binding.mqtt.discovery.TopicSubscribe;
import org.eclipse.smarthome.binding.mqtt.handler.AbstractBrokerHandler;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.io.transport.mqtt.MqttBrokerConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class TopicSubscribeMultiConnection {
    private final Logger logger = LoggerFactory.getLogger(TopicSubscribeMultiConnection.class);
    protected final Map<ThingUID, TopicSubscribe> observedBrokerHandlers = new HashMap<ThingUID, TopicSubscribe>();
    protected final MQTTTopicDiscoveryParticipant messageReceivedListener;
    protected final String topic;

    public TopicSubscribeMultiConnection(MQTTTopicDiscoveryParticipant messageReceivedListener, String topic) {
        this.messageReceivedListener = messageReceivedListener;
        this.topic = topic;
    }

    public void add(AbstractBrokerHandler handler) {
        ThingUID bridgeUid = handler.getThing().getUID();
        handler.getConnectionAsync().thenAccept(connection -> {
            TopicSubscribe o = new TopicSubscribe((MqttBrokerConnection)connection, this.topic, this.messageReceivedListener, bridgeUid);
            this.observedBrokerHandlers.put(bridgeUid, o);
            ((CompletableFuture)o.start().exceptionally(e -> {
                this.logger.warn("Failed to MQTT subscribe for {} on topic {}", (Object)bridgeUid, (Object)this.topic);
                return false;
            })).thenRun(() -> this.logger.trace("Found suitable bridge {} for listing to topic {}", (Object)bridgeUid, (Object)this.topic));
        });
    }

    public void remove(AbstractBrokerHandler handler) {
        TopicSubscribe observedBrokerHandler = this.observedBrokerHandlers.remove(handler.getThing().getUID());
        if (observedBrokerHandler != null) {
            observedBrokerHandler.stop();
        }
    }

    public CompletableFuture<Boolean> stop() {
        return this.observedBrokerHandlers.values().stream().map(v -> v.stop()).reduce(CompletableFuture.completedFuture(true), (a, v) -> a.thenCompose(b -> v));
    }
}

