/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.internal.discovery;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.smarthome.binding.mqtt.MqttBindingConstants;
import org.eclipse.smarthome.config.discovery.AbstractDiscoveryService;
import org.eclipse.smarthome.config.discovery.DiscoveryResultBuilder;
import org.eclipse.smarthome.config.discovery.DiscoveryService;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.io.transport.mqtt.MqttBrokerConnection;
import org.eclipse.smarthome.io.transport.mqtt.MqttService;
import org.eclipse.smarthome.io.transport.mqtt.MqttServiceObserver;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={DiscoveryService.class}, configurationPid="discovery.systemmqttbroker")
public class MqttServiceDiscoveryService
extends AbstractDiscoveryService
implements MqttServiceObserver {
    private final Logger logger = LoggerFactory.getLogger(MqttServiceDiscoveryService.class);
    MqttService mqttService;

    public MqttServiceDiscoveryService() {
        super(Stream.of(MqttBindingConstants.BRIDGE_TYPE_SYSTEMBROKER, MqttBindingConstants.BRIDGE_TYPE_BROKER).collect(Collectors.toSet()), 0, true);
    }

    @Activate
    protected void activate(Map<String, Object> config) {
        super.activate(config);
    }

    @Deactivate
    protected void deactivate() {
        super.deactivate();
    }

    @Reference
    public void setMqttService(MqttService service) {
        this.mqttService = service;
    }

    public void unsetMqttService(MqttService service) {
        this.mqttService = null;
    }

    protected void startScan() {
        this.mqttService.addBrokersListener((MqttServiceObserver)this);
        this.mqttService.getAllBrokerConnections().forEach((brokerId, broker) -> this.brokerAdded((String)brokerId, (MqttBrokerConnection)broker));
        this.stopScan();
    }

    protected void startBackgroundDiscovery() {
        if (this.mqttService == null) {
            return;
        }
        this.mqttService.addBrokersListener((MqttServiceObserver)this);
        this.mqttService.getAllBrokerConnections().forEach((brokerId, broker) -> this.brokerAdded((String)brokerId, (MqttBrokerConnection)broker));
    }

    protected void stopBackgroundDiscovery() {
        if (this.mqttService == null) {
            return;
        }
        this.mqttService.removeBrokersListener((MqttServiceObserver)this);
    }

    public void brokerAdded(String brokerId, MqttBrokerConnection broker) {
        this.logger.trace("Found broker connection {}", (Object)brokerId);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("host", broker.getHost());
        properties.put("port", broker.getPort());
        properties.put("brokerid", brokerId);
        ThingUID thingUID = new ThingUID(MqttBindingConstants.BRIDGE_TYPE_SYSTEMBROKER, brokerId);
        this.thingDiscovered(DiscoveryResultBuilder.create((ThingUID)thingUID).withProperties(properties).withRepresentationProperty("brokerid").withLabel("MQTT Broker").build());
    }

    public void brokerRemoved(String brokerId, MqttBrokerConnection broker) {
        ThingUID thingUID = new ThingUID(MqttBindingConstants.BRIDGE_TYPE_SYSTEMBROKER, brokerId);
        this.thingRemoved(thingUID);
    }
}

