/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.internal.ssl;

import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.internal.ssl.Pin;
import org.eclipse.smarthome.binding.mqtt.internal.ssl.PinMessageDigest;
import org.eclipse.smarthome.binding.mqtt.internal.ssl.PinType;
import org.eclipse.smarthome.binding.mqtt.internal.ssl.PinnedCallback;

@NonNullByDefault
public class PinTrustManager
extends X509ExtendedTrustManager {
    List<Pin> pins = new ArrayList<Pin>();
    protected @Nullable PinnedCallback callback;

    public void addPinning(Pin pin) {
        this.pins.add(pin);
    }

    public void setCallback(PinnedCallback callback) {
        this.callback = callback;
    }

    @Override
    public void checkClientTrusted(X509Certificate @Nullable [] chain, @Nullable String authType) throws CertificateException {
        throw new UnsupportedOperationException();
    }

    protected byte[] getEncoded(PinType type, X509Certificate cert) throws CertificateEncodingException {
        switch (type) {
            case CERTIFICATE_TYPE: {
                return cert.getEncoded();
            }
            case PUBLIC_KEY_TYPE: {
                return cert.getPublicKey().getEncoded();
            }
        }
        throw new CertificateEncodingException("Type unknown");
    }

    PinMessageDigest getMessageDigestForSigAlg(String sigAlg) throws CertificateException {
        Matcher matcher = Pattern.compile("(\\D*)(\\d+)").matcher(sigAlg);
        matcher.find();
        String sigAlgName = matcher.group(1);
        String sigAlgBits = matcher.group(2);
        try {
            return new PinMessageDigest(String.valueOf(sigAlgName) + "-" + sigAlgBits);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertificateException(e);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate @Nullable [] chainN, @Nullable String authType) throws CertificateException {
        X509Certificate[] chain = chainN;
        if (chain == null) {
            return;
        }
        PinMessageDigest digestForSigAlg = this.getMessageDigestForSigAlg(chain[0].getSigAlgName());
        PinnedCallback callback = this.callback;
        for (Pin pin : this.pins) {
            byte[] origData = this.getEncoded(pin.getType(), chain[0]);
            if (pin.isLearning()) {
                pin.setCheckMode(digestForSigAlg, digestForSigAlg.digest(origData));
                if (callback == null) continue;
                callback.pinnedLearnedHash(pin);
                continue;
            }
            PinMessageDigest hashDigest = pin.hashDigest;
            if (hashDigest == null) {
                throw new CertificateException("No hashDigest given!");
            }
            byte[] digestData = hashDigest.digest(origData);
            if (pin.isEqual(digestData)) continue;
            if (callback != null) {
                callback.pinnedConnectionDenied(pin);
            }
            throw new CertificateException(String.valueOf(pin.getType().name()) + " pinning denied access. Destination pin is " + hashDigest.toHexString(digestData) + "' but expected: " + pin.toString());
        }
        if (callback != null) {
            callback.pinnedConnectionAccepted();
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    @Override
    public void checkClientTrusted(X509Certificate @Nullable [] chain, @Nullable String authType, @Nullable Socket socket) throws CertificateException {
        this.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkClientTrusted(X509Certificate @Nullable [] chain, @Nullable String authType, @Nullable SSLEngine sslEngine) throws CertificateException {
        this.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate @Nullable [] chain, @Nullable String authType, @Nullable Socket socket) throws CertificateException {
        this.checkServerTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate @Nullable [] chain, @Nullable String authType, @Nullable SSLEngine sslEngine) throws CertificateException {
        this.checkServerTrusted(chain, authType);
    }
}

