/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.internal.ssl;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.mqtt.internal.ssl.PinTrustManager;
import org.eclipse.smarthome.io.transport.mqtt.sslcontext.SSLContextProvider;
import org.osgi.service.cm.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class PinningSSLContextProvider
implements SSLContextProvider {
    private final Logger logger = LoggerFactory.getLogger(PinningSSLContextProvider.class);
    final PinTrustManager trustManager;

    public PinningSSLContextProvider(PinTrustManager pinTrustManager) {
        this.trustManager = pinTrustManager;
    }

    public SSLContext getContext() throws ConfigurationException {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, new TrustManager[]{this.trustManager}, new SecureRandom());
            return sslContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            this.logger.warn("SSL configuration failed", (Throwable)e);
            throw new ConfigurationException("ssl", e.getMessage());
        }
    }
}

