/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.onewire.internal.OwException;
import org.eclipse.smarthome.binding.onewire.internal.OwPageBuffer;
import org.eclipse.smarthome.binding.onewire.internal.SensorId;
import org.eclipse.smarthome.binding.onewire.internal.device.OwSensorType;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseBridgeHandler;

@NonNullByDefault
public class DS2438Configuration {
    private static final Pattern ASSOC_SENSOR_ID_PATTERN = Pattern.compile("^(26|28|3A)([0-9A-Fa-f]{12})[0-9A-Fa-f]{2}$");
    private OwSensorType sensorSubType;
    private String vendor;
    private String hwRevision;
    private String prodDate;
    private final Map<SensorId, OwSensorType> associatedSensors;

    public DS2438Configuration(OwBaseBridgeHandler bridgeHandler, SensorId sensorId) throws OwException {
        block43: {
            String sensorTypeId;
            this.sensorSubType = OwSensorType.DS2438;
            this.vendor = "Dallas/Maxim";
            this.hwRevision = "0";
            this.prodDate = "unknown";
            this.associatedSensors = new HashMap<SensorId, OwSensorType>();
            OwSensorType sensorType = bridgeHandler.getType(sensorId);
            if (sensorType != OwSensorType.DS2438) {
                throw new OwException("sensor " + sensorId.getId() + " is not a DS2438!");
            }
            OwPageBuffer pageBuffer = bridgeHandler.readPages(sensorId);
            switch (sensorTypeId = pageBuffer.getPageString(3).substring(0, 2)) {
                case "19": {
                    this.vendor = "iButtonLink";
                    this.sensorSubType = OwSensorType.MS_TH;
                    break;
                }
                case "1A": {
                    this.vendor = "iButtonLink";
                    this.sensorSubType = OwSensorType.MS_TV;
                    break;
                }
                case "1B": {
                    this.vendor = "iButtonLink";
                    this.sensorSubType = OwSensorType.MS_TL;
                    break;
                }
                case "1C": {
                    this.vendor = "iButtonLink";
                    this.sensorSubType = OwSensorType.MS_TC;
                    break;
                }
                case "F1": 
                case "F3": {
                    this.vendor = "Elaborated Networks";
                    this.sensorSubType = OwSensorType.MS_TH;
                    break;
                }
                case "F2": {
                    this.vendor = "Elaborated Networks";
                    this.sensorSubType = OwSensorType.MS_TH_S;
                    break;
                }
                case "F4": {
                    this.vendor = "Elaborated Networks";
                    this.sensorSubType = OwSensorType.MS_TV;
                }
            }
            if (this.sensorSubType != OwSensorType.MS_TH && this.sensorSubType != OwSensorType.MS_TH_S && this.sensorSubType != OwSensorType.MS_TV) break block43;
            int i = 4;
            while (i < 7) {
                block44: {
                    String str = new StringBuilder(pageBuffer.getPageString(i)).insert(2, ".").delete(15, 17).toString();
                    Matcher matcher = SensorId.SENSOR_ID_PATTERN.matcher(str);
                    if (!matcher.matches()) break block44;
                    SensorId associatedSensorId = new SensorId(String.valueOf(sensorId.getPath()) + matcher.group(2));
                    switch (matcher.group(2).substring(0, 2)) {
                        case "26": {
                            DS2438Configuration associatedDs2438Config = new DS2438Configuration(bridgeHandler, associatedSensorId);
                            this.associatedSensors.put(associatedSensorId, associatedDs2438Config.getSensorSubType());
                            this.associatedSensors.putAll(associatedDs2438Config.getAssociatedSensors());
                            break;
                        }
                        case "28": {
                            this.associatedSensors.put(associatedSensorId, OwSensorType.DS18B20);
                            break;
                        }
                        case "3A": {
                            this.associatedSensors.put(associatedSensorId, OwSensorType.DS2413);
                        }
                    }
                }
                ++i;
            }
            this.prodDate = String.format("%d/%d", pageBuffer.getByte(5, 0), 256 * pageBuffer.getByte(5, 1) + pageBuffer.getByte(5, 2));
            this.hwRevision = String.valueOf(pageBuffer.getByte(5, 3));
        }
    }

    public Map<SensorId, OwSensorType> getAssociatedSensors() {
        return this.associatedSensors;
    }

    public List<SensorId> getAssociatedSensorIds() {
        return new ArrayList<SensorId>(this.associatedSensors.keySet());
    }

    public List<SensorId> getAssociatedSensorIds(OwSensorType sensorType) {
        return this.associatedSensors.entrySet().stream().filter(s -> s.getValue() == sensorType).map(s -> (SensorId)s.getKey()).collect(Collectors.toList());
    }

    public List<OwSensorType> getAssociatedSensorTypes() {
        return new ArrayList<OwSensorType>(this.associatedSensors.values());
    }

    public int getAssociatedSensorCount() {
        return this.associatedSensors.size();
    }

    public String getHardwareRevision() {
        return this.hwRevision;
    }

    public String getProductionDate() {
        return this.prodDate;
    }

    public OwSensorType getSensorSubType() {
        return this.sensorSubType;
    }

    public String getVendor() {
        return this.vendor;
    }

    public static OwSensorType getMultisensorType(OwSensorType mainsensorType, List<OwSensorType> associatedSensorTypes) {
        OwSensorType multisensorType = OwSensorType.UNKNOWN;
        switch (associatedSensorTypes.size()) {
            case 0: {
                multisensorType = mainsensorType;
                break;
            }
            case 1: {
                if (mainsensorType == OwSensorType.MS_TH_S && associatedSensorTypes.contains((Object)OwSensorType.DS18B20)) {
                    multisensorType = OwSensorType.BMS_S;
                    break;
                }
                if (mainsensorType != OwSensorType.MS_TH || !associatedSensorTypes.contains((Object)OwSensorType.DS18B20)) break;
                multisensorType = OwSensorType.BMS;
                break;
            }
            case 3: {
                if (mainsensorType == OwSensorType.MS_TH_S && associatedSensorTypes.contains((Object)OwSensorType.MS_TV) && associatedSensorTypes.contains((Object)OwSensorType.DS18B20) && associatedSensorTypes.contains((Object)OwSensorType.DS2413)) {
                    multisensorType = OwSensorType.AMS_S;
                    break;
                }
                if (mainsensorType != OwSensorType.MS_TH || !associatedSensorTypes.contains((Object)OwSensorType.MS_TV) || !associatedSensorTypes.contains((Object)OwSensorType.DS18B20) || !associatedSensorTypes.contains((Object)OwSensorType.DS2413)) break;
                multisensorType = OwSensorType.AMS;
            }
        }
        return multisensorType;
    }
}

