/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.onewire.internal.device.OwSensorType;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;

@NonNullByDefault
public class OwBindingConstants {
    public static final String BINDING_ID = "onewire";
    public static final ThingTypeUID THING_TYPE_OWSERVER = new ThingTypeUID("onewire", "owserver");
    public static final ThingTypeUID THING_TYPE_TEMPERATURE = new ThingTypeUID("onewire", "temperature");
    public static final ThingTypeUID THING_TYPE_IBUTTON = new ThingTypeUID("onewire", "ibutton");
    public static final ThingTypeUID THING_TYPE_DIGITALIO = new ThingTypeUID("onewire", "digitalio");
    public static final ThingTypeUID THING_TYPE_DIGITALIO2 = new ThingTypeUID("onewire", "digitalio2");
    public static final ThingTypeUID THING_TYPE_DIGITALIO8 = new ThingTypeUID("onewire", "digitalio8");
    public static final ThingTypeUID THING_TYPE_MS_TX = new ThingTypeUID("onewire", "ms-tx");
    public static final ThingTypeUID THING_TYPE_BMS = new ThingTypeUID("onewire", "bms");
    public static final ThingTypeUID THING_TYPE_AMS = new ThingTypeUID("onewire", "ams");
    public static final ThingTypeUID THING_TYPE_COUNTER2 = new ThingTypeUID("onewire", "counter2");
    public static final ThingTypeUID THING_TYPE_EDS_ENV = new ThingTypeUID("onewire", "edsenv");
    public static final ThingTypeUID THING_TYPE_MS_TH = new ThingTypeUID("onewire", "ms-th");
    public static final ThingTypeUID THING_TYPE_MS_TV = new ThingTypeUID("onewire", "ms-tv");
    public static final Set<ThingTypeUID> SUPPORTED_THING_TYPES = new HashSet<ThingTypeUID>(Arrays.asList(THING_TYPE_OWSERVER, THING_TYPE_TEMPERATURE, THING_TYPE_IBUTTON, THING_TYPE_DIGITALIO, THING_TYPE_DIGITALIO2, THING_TYPE_DIGITALIO8, THING_TYPE_AMS, THING_TYPE_BMS, THING_TYPE_MS_TH, THING_TYPE_MS_TX, THING_TYPE_MS_TV, THING_TYPE_EDS_ENV, THING_TYPE_COUNTER2));
    public static final String CONFIG_ADDRESS = "network-address";
    public static final String CONFIG_PORT = "port";
    public static final String CONFIG_ID = "id";
    public static final String CONFIG_RESOLUTION = "resolution";
    public static final String CONFIG_IGNORE_POR = "ignorepor";
    public static final String CONFIG_REFRESH = "refresh";
    public static final String CONFIG_DIGITALREFRESH = "digitalrefresh";
    public static final String CONFIG_OFFSET = "offset";
    public static final String CONFIG_HUMIDITY = "humiditytype";
    public static final String CONFIG_DIGITAL_MODE = "mode";
    public static final String CONFIG_DIGITAL_LOGIC = "logic";
    public static final String CONFIG_TEMPERATURESENSOR = "temperaturesensor";
    public static final String CONFIG_LIGHTSENSOR = "lightsensor";
    public static final String PROPERTY_MODELID = "modelId";
    public static final String PROPERTY_VENDOR = "vendor";
    public static final String PROPERTY_SENSORCOUNT = "sensorCount";
    public static final String PROPERTY_PROD_DATE = "prodDate";
    public static final String PROPERTY_HW_REVISION = "hwRevision";
    public static final String PROPERTY_THING_TYPE_VERSION = "thingTypeVersion";
    public static final String CHANNEL_HUMIDITY = "humidity";
    public static final String CHANNEL_ABSOLUTE_HUMIDITY = "absolutehumidity";
    public static final String CHANNEL_DEWPOINT = "dewpoint";
    public static final String CHANNEL_PRESENT = "present";
    public static final String CHANNEL_TEMPERATURE = "temperature";
    public static final String CHANNEL_LIGHT = "light";
    public static final String CHANNEL_SUPPLYVOLTAGE = "supplyvoltage";
    public static final String CHANNEL_VOLTAGE = "voltage";
    public static final String CHANNEL_CURRENT = "current";
    public static final String CHANNEL_PRESSURE = "pressure";
    public static final String CHANNEL_DIGITAL = "digital";
    public static final String CHANNEL_COUNTER = "counter";
    public static final Map<OwSensorType, ThingTypeUID> THING_TYPE_MAP = Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<OwSensorType, ThingTypeUID>(OwSensorType.DS1420, THING_TYPE_IBUTTON), new AbstractMap.SimpleEntry<OwSensorType, ThingTypeUID>(OwSensorType.DS18B20, THING_TYPE_TEMPERATURE), new AbstractMap.SimpleEntry<OwSensorType, ThingTypeUID>(OwSensorType.DS18S20, THING_TYPE_TEMPERATURE), new AbstractMap.SimpleEntry<OwSensorType, ThingTypeUID>(OwSensorType.DS1822, THING_TYPE_TEMPERATURE), new AbstractMap.SimpleEntry<OwSensorType, ThingTypeUID>(OwSensorType.DS1923, THING_TYPE_MS_TX), new AbstractMap.SimpleEntry<OwSensorType, ThingTypeUID>(OwSensorType.DS2401, THING_TYPE_IBUTTON), new AbstractMap.SimpleEntry<OwSensorType, ThingTypeUID>(OwSensorType.DS2405, THING_TYPE_DIGITALIO), new AbstractMap.SimpleEntry<OwSensorType, ThingTypeUID>(OwSensorType.DS2406, THING_TYPE_DIGITALIO2), new AbstractMap.SimpleEntry<OwSensorType, ThingTypeUID>(OwSensorType.DS2408, THING_TYPE_DIGITALIO8), new AbstractMap.SimpleEntry<OwSensorType, ThingTypeUID>(OwSensorType.DS2413, THING_TYPE_DIGITALIO2), new AbstractMap.SimpleEntry<OwSensorType, ThingTypeUID>(OwSensorType.DS2438, THING_TYPE_MS_TX), new AbstractMap.SimpleEntry<OwSensorType, ThingTypeUID>(OwSensorType.MS_TC, THING_TYPE_MS_TX), new AbstractMap.SimpleEntry<OwSensorType, ThingTypeUID>(OwSensorType.MS_TH, THING_TYPE_MS_TX), new AbstractMap.SimpleEntry<OwSensorType, ThingTypeUID>(OwSensorType.MS_TL, THING_TYPE_MS_TX), new AbstractMap.SimpleEntry<OwSensorType, ThingTypeUID>(OwSensorType.MS_TV, THING_TYPE_MS_TX), new AbstractMap.SimpleEntry<OwSensorType, ThingTypeUID>(OwSensorType.BMS, THING_TYPE_BMS), new AbstractMap.SimpleEntry<OwSensorType, ThingTypeUID>(OwSensorType.BMS_S, THING_TYPE_BMS), new AbstractMap.SimpleEntry<OwSensorType, ThingTypeUID>(OwSensorType.AMS, THING_TYPE_AMS), new AbstractMap.SimpleEntry<OwSensorType, ThingTypeUID>(OwSensorType.AMS_S, THING_TYPE_AMS), new AbstractMap.SimpleEntry<OwSensorType, ThingTypeUID>(OwSensorType.DS2423, THING_TYPE_COUNTER2), new AbstractMap.SimpleEntry<OwSensorType, ThingTypeUID>(OwSensorType.EDS0064, THING_TYPE_EDS_ENV), new AbstractMap.SimpleEntry<OwSensorType, ThingTypeUID>(OwSensorType.EDS0065, THING_TYPE_EDS_ENV), new AbstractMap.SimpleEntry<OwSensorType, ThingTypeUID>(OwSensorType.EDS0066, THING_TYPE_EDS_ENV), new AbstractMap.SimpleEntry<OwSensorType, ThingTypeUID>(OwSensorType.EDS0067, THING_TYPE_EDS_ENV), new AbstractMap.SimpleEntry<OwSensorType, ThingTypeUID>(OwSensorType.EDS0068, THING_TYPE_EDS_ENV)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    public static final Map<ThingTypeUID, String> THING_LABEL_MAP = Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<ThingTypeUID, String>(THING_TYPE_TEMPERATURE, "Temperature sensor"), new AbstractMap.SimpleEntry<ThingTypeUID, String>(THING_TYPE_IBUTTON, "iButton"), new AbstractMap.SimpleEntry<ThingTypeUID, String>(THING_TYPE_DIGITALIO, "Digital I/O"), new AbstractMap.SimpleEntry<ThingTypeUID, String>(THING_TYPE_DIGITALIO2, "Dual Digital I/O"), new AbstractMap.SimpleEntry<ThingTypeUID, String>(THING_TYPE_DIGITALIO8, "Octal Digital I/O"), new AbstractMap.SimpleEntry<ThingTypeUID, String>(THING_TYPE_MS_TX, "Multisensor"), new AbstractMap.SimpleEntry<ThingTypeUID, String>(THING_TYPE_BMS, "Elaborated Networks BMS"), new AbstractMap.SimpleEntry<ThingTypeUID, String>(THING_TYPE_AMS, "Elaborated Networks AMS"), new AbstractMap.SimpleEntry<ThingTypeUID, String>(THING_TYPE_COUNTER2, "Dual Counter"), new AbstractMap.SimpleEntry<ThingTypeUID, String>(THING_TYPE_EDS_ENV, "EDS Environmental Sensor")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    public static final Map<String, String> ACCEPTED_ITEM_TYPES_MAP = Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<String, String>("humidity", "Number:Dimensionless"), new AbstractMap.SimpleEntry<String, String>("absolutehumidity", "Number:Density"), new AbstractMap.SimpleEntry<String, String>("dewpoint", "Number:Temperature"), new AbstractMap.SimpleEntry<String, String>("temperature", "Number:Temperature"), new AbstractMap.SimpleEntry<String, String>("light", "Number:Illuminance"), new AbstractMap.SimpleEntry<String, String>("pressure", "Number:Pressure"), new AbstractMap.SimpleEntry<String, String>("voltage", "Number:ElectricPotential"), new AbstractMap.SimpleEntry<String, String>("supplyvoltage", "Number:ElectricPotential"), new AbstractMap.SimpleEntry<String, String>("current", "Number:ElectricCurrent"), new AbstractMap.SimpleEntry<String, String>("counter", "Number"), new AbstractMap.SimpleEntry<String, String>("digital", "Switch"), new AbstractMap.SimpleEntry<String, String>("present", "Switch")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    public static final ChannelTypeUID CHANNEL_TYPE_UID_ABSHUMIDITY = new ChannelTypeUID("onewire", "abshumidity");
    public static final ChannelTypeUID CHANNEL_TYPE_UID_CURRENT = new ChannelTypeUID("onewire", "current");
    public static final ChannelTypeUID CHANNEL_TYPE_UID_DEWPOINT = new ChannelTypeUID("onewire", "dewpoint");
    public static final ChannelTypeUID CHANNEL_TYPE_UID_HUMIDITY = new ChannelTypeUID("onewire", "humidity");
    public static final ChannelTypeUID CHANNEL_TYPE_UID_HUMIDITYCONF = new ChannelTypeUID("onewire", "humidityconf");
    public static final ChannelTypeUID CHANNEL_TYPE_UID_LIGHT = new ChannelTypeUID("onewire", "light");
    public static final ChannelTypeUID CHANNEL_TYPE_UID_PRESSURE = new ChannelTypeUID("onewire", "pressure");
    public static final ChannelTypeUID CHANNEL_TYPE_UID_TEMPERATURE = new ChannelTypeUID("onewire", "temperature");
    public static final ChannelTypeUID CHANNEL_TYPE_UID_TEMPERATURE_POR = new ChannelTypeUID("onewire", "temperature-por");
    public static final ChannelTypeUID CHANNEL_TYPE_UID_TEMPERATURE_POR_RES = new ChannelTypeUID("onewire", "temperature-por-res");
    public static final ChannelTypeUID CHANNEL_TYPE_UID_VOLTAGE = new ChannelTypeUID("onewire", "voltage");
    public static final ChannelTypeUID CHANNEL_TYPE_UID_OWFS_NUMBER = new ChannelTypeUID("onewire", "owfs-number");
    public static final ChannelTypeUID CHANNEL_TYPE_UID_OWFS_STRING = new ChannelTypeUID("onewire", "owfs-string");
}

