/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal;

import java.nio.ByteBuffer;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.core.util.HexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class OwPageBuffer {
    private final Logger logger = LoggerFactory.getLogger(OwPageBuffer.class);
    public static final int PAGE_SIZE = 8;
    private ByteBuffer byteBuffer;

    public OwPageBuffer() {
        this.byteBuffer = ByteBuffer.allocate(0);
    }

    public OwPageBuffer(int pageNum) {
        this.byteBuffer = ByteBuffer.allocate(pageNum * 8);
    }

    public OwPageBuffer(byte[] bytes) {
        if (bytes.length % 8 != 0) {
            this.byteBuffer = ByteBuffer.allocate((bytes.length / 8 + 1) * 8);
            this.logger.warn("initializing buffer which is not aligned to pages (requested size is {})!", (Object)bytes.length);
        } else {
            this.byteBuffer = ByteBuffer.allocate(bytes.length);
        }
        this.byteBuffer.put(bytes);
    }

    public int length() {
        return this.byteBuffer.limit() / 8;
    }

    public byte[] getPage(int pageNum) {
        byte[] page = new byte[8];
        this.byteBuffer.position(pageNum * 8);
        this.byteBuffer.get(page);
        return page;
    }

    public String getPageString(int pageNum) {
        return HexUtils.bytesToHex((byte[])this.getPage(pageNum));
    }

    public int getByte(int pageNum, int byteNum) {
        int index = pageNum * 8 + byteNum;
        if (index < this.byteBuffer.limit()) {
            return this.byteBuffer.get(index) & 0xFF;
        }
        return 0;
    }

    public void setByte(int pageNum, int byteNum, byte value) {
        int index = pageNum * 8 + byteNum;
        if (index >= this.byteBuffer.limit()) {
            throw new IllegalArgumentException("index out of range");
        }
        this.byteBuffer.put(index, value);
    }

    public byte[] getBytes() {
        return this.byteBuffer.array();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(new String("["));
        int i = 0;
        while (i < this.length()) {
            if (i > 0) {
                s.append(new String(", "));
            }
            s.append(this.getPageString(i));
            ++i;
        }
        s.append(new String("]"));
        return s.toString();
    }
}

