/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class SensorId {
    public static final Pattern SENSOR_ID_PATTERN = Pattern.compile("^\\/?((?:(?:1F\\.[0-9A-Fa-f]{12})\\/(?:main|aux)\\/)+)?([0-9A-Fa-f]{2}\\.[0-9A-Fa-f]{12})$");
    private final String sensorId;
    private final String path;
    private final String fullPath;

    public SensorId(String fullPath) {
        Matcher matcher = SENSOR_ID_PATTERN.matcher(fullPath);
        if (!matcher.matches() || matcher.groupCount() != 2) {
            throw new IllegalArgumentException();
        }
        this.path = matcher.group(1) == null ? "" : matcher.group(1);
        this.sensorId = matcher.group(2);
        this.fullPath = "/" + this.path + this.sensorId;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public String getId() {
        return this.sensorId;
    }

    public String getPath() {
        return this.path;
    }

    public String getFamilyId() {
        return this.sensorId.substring(0, 2);
    }

    public String toString() {
        return this.fullPath;
    }

    public int hashCode() {
        return this.fullPath.hashCode();
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SensorId)) {
            return false;
        }
        return ((SensorId)o).fullPath.equals(this.fullPath);
    }
}

