/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal.device;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.onewire.internal.OwException;
import org.eclipse.smarthome.binding.onewire.internal.SensorId;
import org.eclipse.smarthome.binding.onewire.internal.device.OwSensorType;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseBridgeHandler;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseThingHandler;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.types.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract class AbstractOwDevice {
    private final Logger logger = LoggerFactory.getLogger(AbstractOwDevice.class);
    protected SensorId sensorId;
    protected OwSensorType sensorType = OwSensorType.UNKNOWN;
    protected OwBaseThingHandler callback;
    protected Boolean isConfigured = false;
    protected Set<String> enabledChannels = new HashSet<String>();

    public AbstractOwDevice(SensorId sensorId, OwBaseThingHandler callback) {
        this.sensorId = sensorId;
        this.callback = callback;
    }

    public abstract void configureChannels() throws OwException;

    public abstract void refresh(OwBaseBridgeHandler var1, Boolean var2) throws OwException;

    public void enableChannel(String channelID) {
        if (!this.enabledChannels.contains(channelID)) {
            this.enabledChannels.add(channelID);
        }
    }

    public void disableChannel(String channelID) {
        if (this.enabledChannels.contains(channelID)) {
            this.enabledChannels.remove(channelID);
        }
    }

    public SensorId getSensorId() {
        return this.sensorId;
    }

    public Boolean checkPresence(OwBaseBridgeHandler bridgeHandler) {
        try {
            State present = bridgeHandler.checkPresence(this.sensorId);
            this.callback.updatePresenceStatus(present);
            return OnOffType.ON.equals((Object)present);
        }
        catch (OwException e) {
            this.logger.debug("error refreshing presence {} on bridge {}: {}", new Object[]{this.sensorId, bridgeHandler.getThing().getUID(), e.getMessage()});
            return false;
        }
    }

    public OwSensorType getSensorType(OwBaseBridgeHandler bridgeHandler) throws OwException {
        if (this.sensorType == OwSensorType.UNKNOWN) {
            this.sensorType = bridgeHandler.getType(this.sensorId);
        }
        return this.sensorType;
    }
}

