/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal.discovery;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.onewire.internal.DS2438Configuration;
import org.eclipse.smarthome.binding.onewire.internal.OwBindingConstants;
import org.eclipse.smarthome.binding.onewire.internal.OwException;
import org.eclipse.smarthome.binding.onewire.internal.OwPageBuffer;
import org.eclipse.smarthome.binding.onewire.internal.SensorId;
import org.eclipse.smarthome.binding.onewire.internal.device.OwSensorType;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseBridgeHandler;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class OwDiscoveryItem {
    private final Logger logger = LoggerFactory.getLogger(OwDiscoveryItem.class);
    private final SensorId sensorId;
    private OwSensorType sensorType = OwSensorType.UNKNOWN;
    private String vendor = "Dallas/Maxim";
    private OwPageBuffer pages = new OwPageBuffer();
    private ThingTypeUID thingTypeUID = new ThingTypeUID("onewire", "");
    private final Map<SensorId, OwSensorType> associatedSensors = new HashMap<SensorId, OwSensorType>();

    public OwDiscoveryItem(OwBaseBridgeHandler bridgeHandler, SensorId sensorId) throws OwException {
        this.sensorId = sensorId;
        this.sensorType = bridgeHandler.getType(sensorId);
        switch (this.sensorType) {
            case DS2438: {
                this.pages = bridgeHandler.readPages(sensorId);
                DS2438Configuration config = new DS2438Configuration(bridgeHandler, sensorId);
                this.associatedSensors.putAll(config.getAssociatedSensors());
                this.logger.trace("found associated sensors: {}", this.associatedSensors);
                this.vendor = config.getVendor();
                this.sensorType = config.getSensorSubType();
                break;
            }
            case EDS: {
                this.vendor = "Embedded Data Systems";
                this.pages = bridgeHandler.readPages(sensorId);
                try {
                    this.sensorType = OwSensorType.valueOf(new String(this.pages.getPage(0), 0, 7, StandardCharsets.US_ASCII));
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.sensorType = OwSensorType.UNKNOWN;
                }
            }
        }
    }

    public OwSensorType getSensorType() {
        return this.sensorType;
    }

    public SensorId getSensorId() {
        return this.sensorId;
    }

    public String getNormalizedSensorId() {
        return this.sensorId.getId().replace(".", "_");
    }

    public String getVendor() {
        return this.vendor;
    }

    public ThingTypeUID getThingTypeUID() throws OwException {
        if (OwBindingConstants.THING_TYPE_MAP.containsKey((Object)this.sensorType)) {
            this.thingTypeUID = OwBindingConstants.THING_TYPE_MAP.get((Object)this.sensorType);
            return this.thingTypeUID;
        }
        throw new OwException((Object)((Object)this.sensorType) + " cannot be mapped to thing type");
    }

    public List<SensorId> getAssociatedSensorIds() {
        return new ArrayList<SensorId>(this.associatedSensors.keySet());
    }

    public void checkSensorType() {
        this.logger.debug("checkSensorType: {} with {}", (Object)this, this.associatedSensors);
        switch (this.sensorType) {
            case MS_TH: 
            case MS_TH_S: {
                this.sensorType = DS2438Configuration.getMultisensorType(this.sensorType, new ArrayList<OwSensorType>(this.associatedSensors.values()));
            }
        }
    }

    public String getLabel() {
        return String.valueOf(OwBindingConstants.THING_LABEL_MAP.get(this.thingTypeUID)) + " (" + this.sensorId.getId() + ")";
    }

    public String toString() {
        return String.format("%s/%s (associated: %d)", new Object[]{this.sensorId, this.sensorType, this.associatedSensors.size()});
    }
}

