/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal.handler;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.onewire.internal.DS2438Configuration;
import org.eclipse.smarthome.binding.onewire.internal.OwBindingConstants;
import org.eclipse.smarthome.binding.onewire.internal.OwDynamicStateDescriptionProvider;
import org.eclipse.smarthome.binding.onewire.internal.OwException;
import org.eclipse.smarthome.binding.onewire.internal.SensorId;
import org.eclipse.smarthome.binding.onewire.internal.device.AbstractOwDevice;
import org.eclipse.smarthome.binding.onewire.internal.device.DS18x20;
import org.eclipse.smarthome.binding.onewire.internal.device.DS2406_DS2413;
import org.eclipse.smarthome.binding.onewire.internal.device.DS2438;
import org.eclipse.smarthome.binding.onewire.internal.device.OwSensorType;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseBridgeHandler;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseThingHandler;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.builder.ThingBuilder;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class AdvancedMultisensorThingHandler
extends OwBaseThingHandler {
    public static final Set<ThingTypeUID> SUPPORTED_THING_TYPES = new HashSet<ThingTypeUID>(Arrays.asList(OwBindingConstants.THING_TYPE_AMS, OwBindingConstants.THING_TYPE_BMS));
    public static final Set<OwSensorType> SUPPORTED_SENSOR_TYPES = Collections.unmodifiableSet(Stream.of(OwSensorType.AMS, OwSensorType.AMS_S, OwSensorType.BMS, OwSensorType.BMS_S).collect(Collectors.toSet()));
    private static final String PROPERTY_DS18B20 = "ds18b20";
    private static final String PROPERTY_DS2413 = "ds2413";
    private static final String PROPERTY_DS2438 = "ds2438";
    private static final Set<String> REQUIRED_PROPERTIES_AMS = Collections.unmodifiableSet(Stream.of("hwRevision", "prodDate", "ds18b20", "ds2438", "ds2413").collect(Collectors.toSet()));
    private static final Set<String> REQUIRED_PROPERTIES_BMS = Collections.unmodifiableSet(Stream.of("hwRevision", "prodDate", "ds18b20").collect(Collectors.toSet()));
    private final Logger logger = LoggerFactory.getLogger(AdvancedMultisensorThingHandler.class);
    private final ThingTypeUID thingType = this.thing.getThingTypeUID();
    private int hwRevision = 0;
    private int digitalRefreshInterval = 10000;
    private long digitalLastRefresh = 0L;

    public AdvancedMultisensorThingHandler(Thing thing, OwDynamicStateDescriptionProvider dynamicStateDescriptionProvider) {
        super(thing, dynamicStateDescriptionProvider, SUPPORTED_SENSOR_TYPES, AdvancedMultisensorThingHandler.getRequiredProperties(thing.getThingTypeUID()));
    }

    @Override
    public void initialize() {
        Configuration configuration = this.getConfig();
        Map properties = this.editProperties();
        if (!super.configure()) {
            return;
        }
        this.hwRevision = Integer.valueOf((String)properties.get("hwRevision"));
        this.digitalRefreshInterval = configuration.containsKey("digitalrefresh") ? ((BigDecimal)configuration.get("digitalrefresh")).intValue() * 1000 : 10000;
        this.digitalLastRefresh = 0L;
        this.sensors.add(new DS2438(this.sensorId, this));
        this.sensors.add(new DS18x20(new SensorId((String)properties.get(PROPERTY_DS18B20)), this));
        if (OwBindingConstants.THING_TYPE_AMS.equals((Object)this.thingType)) {
            this.sensors.add(new DS2438(new SensorId((String)properties.get(PROPERTY_DS2438)), this));
            this.sensors.add(new DS2406_DS2413(new SensorId((String)properties.get(PROPERTY_DS2413)), this));
        }
        this.scheduler.execute(() -> this.configureThingChannels());
    }

    @Override
    public void refresh(OwBaseBridgeHandler bridgeHandler, long now) {
        try {
            Boolean forcedRefresh;
            if (now >= this.digitalLastRefresh + (long)this.digitalRefreshInterval && this.thingType == OwBindingConstants.THING_TYPE_AMS) {
                this.logger.trace("refreshing digital {}", (Object)this.thing.getUID());
                forcedRefresh = this.digitalLastRefresh == 0L;
                this.digitalLastRefresh = now;
                if (!((AbstractOwDevice)this.sensors.get(3)).checkPresence(bridgeHandler).booleanValue()) {
                    return;
                }
                ((AbstractOwDevice)this.sensors.get(3)).refresh(bridgeHandler, forcedRefresh);
            }
            if (now >= this.lastRefresh + this.refreshInterval) {
                if (!((AbstractOwDevice)this.sensors.get(0)).checkPresence(bridgeHandler).booleanValue()) {
                    return;
                }
                this.logger.trace("refreshing analog {}", (Object)this.thing.getUID());
                forcedRefresh = this.lastRefresh == 0L;
                this.lastRefresh = now;
                if (this.thingType.equals((Object)OwBindingConstants.THING_TYPE_AMS)) {
                    int i = 0;
                    while (i < this.sensors.size() - 1) {
                        ((AbstractOwDevice)this.sensors.get(i)).refresh(bridgeHandler, forcedRefresh);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < this.sensors.size()) {
                        ((AbstractOwDevice)this.sensors.get(i)).refresh(bridgeHandler, forcedRefresh);
                        ++i;
                    }
                }
            }
        }
        catch (OwException e) {
            this.logger.debug("{}: refresh exception '{}'", (Object)this.thing.getUID(), (Object)e.getMessage());
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, "refresh exception");
        }
    }

    private void configureThingChannels() {
        Configuration configuration = this.getConfig();
        ThingBuilder thingBuilder = this.editThing();
        Channel temperatureChannel = this.addChannelIfMissing(thingBuilder, "temperature", OwBindingConstants.CHANNEL_TYPE_UID_TEMPERATURE);
        if (configuration.containsKey("temperaturesensor") && configuration.get("temperaturesensor").equals("DS18B20")) {
            if (!OwBindingConstants.CHANNEL_TYPE_UID_TEMPERATURE_POR_RES.equals((Object)temperatureChannel.getChannelTypeUID())) {
                this.removeChannelIfExisting(thingBuilder, "temperature");
                this.addChannelIfMissing(thingBuilder, "temperature", OwBindingConstants.CHANNEL_TYPE_UID_TEMPERATURE_POR_RES, temperatureChannel.getConfiguration());
            }
            ((AbstractOwDevice)this.sensors.get(1)).enableChannel("temperature");
        } else {
            if (!OwBindingConstants.CHANNEL_TYPE_UID_TEMPERATURE.equals((Object)temperatureChannel.getChannelTypeUID())) {
                this.removeChannelIfExisting(thingBuilder, "temperature");
                this.addChannelIfMissing(thingBuilder, "temperature", OwBindingConstants.CHANNEL_TYPE_UID_TEMPERATURE, temperatureChannel.getConfiguration());
            }
            ((AbstractOwDevice)this.sensors.get(0)).enableChannel("temperature");
        }
        Channel humidityChannel = this.thing.getChannel("humidity");
        if (humidityChannel != null && !humidityChannel.getConfiguration().containsKey("humiditytype")) {
            this.removeChannelIfExisting(thingBuilder, "humidity");
            this.addChannelIfMissing(thingBuilder, "humidity", OwBindingConstants.CHANNEL_TYPE_UID_HUMIDITY, new Configuration((Map)new HashMap<String, Object>(){
                {
                    this.put("humiditytype", "/HIH4000/humidity");
                }
            }));
        }
        ((AbstractOwDevice)this.sensors.get(0)).enableChannel("humidity");
        ((AbstractOwDevice)this.sensors.get(0)).enableChannel("absolutehumidity");
        ((AbstractOwDevice)this.sensors.get(0)).enableChannel("dewpoint");
        ((AbstractOwDevice)this.sensors.get(0)).enableChannel("supplyvoltage");
        if (configuration.containsKey("lightsensor") && ((Boolean)configuration.get("lightsensor")).booleanValue()) {
            this.removeChannelIfExisting(thingBuilder, "current");
            this.addChannelIfMissing(thingBuilder, "light", OwBindingConstants.CHANNEL_TYPE_UID_LIGHT);
            ((AbstractOwDevice)this.sensors.get(0)).enableChannel("light");
            if (this.hwRevision <= 13) {
                ((DS2438)this.sensors.get(0)).setLightSensorType(DS2438.LightSensorType.ELABNET_V1);
            } else {
                ((DS2438)this.sensors.get(0)).setLightSensorType(DS2438.LightSensorType.ELABNET_V2);
            }
        } else {
            this.removeChannelIfExisting(thingBuilder, "light");
            this.addChannelIfMissing(thingBuilder, "current", OwBindingConstants.CHANNEL_TYPE_UID_CURRENT);
            ((AbstractOwDevice)this.sensors.get(0)).enableChannel("current");
        }
        if (OwBindingConstants.THING_TYPE_AMS.equals((Object)this.thingType)) {
            ((AbstractOwDevice)this.sensors.get(2)).enableChannel("voltage");
            this.digitalRefreshInterval = configuration.containsKey("digitalrefresh") ? ((BigDecimal)configuration.get("digitalrefresh")).intValue() * 1000 : 10000;
        }
        this.updateThing(thingBuilder.build());
        try {
            int i = 0;
            while (i < this.sensors.size()) {
                ((AbstractOwDevice)this.sensors.get(i)).configureChannels();
                ++i;
            }
        }
        catch (OwException e) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, e.getMessage());
            return;
        }
        this.validConfig = true;
        this.updatePresenceStatus((State)UnDefType.UNDEF);
    }

    @Override
    public Map<String, String> updateSensorProperties(OwBaseBridgeHandler bridgeHandler) throws OwException {
        HashMap<String, String> properties = new HashMap<String, String>();
        DS2438Configuration ds2438configuration = new DS2438Configuration(bridgeHandler, this.sensorId);
        this.sensorType = DS2438Configuration.getMultisensorType(ds2438configuration.getSensorSubType(), ds2438configuration.getAssociatedSensorTypes());
        properties.put("modelId", this.sensorType.toString());
        properties.put("vendor", ds2438configuration.getVendor());
        properties.put("prodDate", ds2438configuration.getProductionDate());
        properties.put("hwRevision", ds2438configuration.getHardwareRevision());
        switch (this.sensorType) {
            case BMS: 
            case BMS_S: {
                properties.put(PROPERTY_DS18B20, ds2438configuration.getAssociatedSensorIds(OwSensorType.DS18B20).get(0).getFullPath());
                break;
            }
            case AMS: 
            case AMS_S: {
                properties.put(PROPERTY_DS18B20, ds2438configuration.getAssociatedSensorIds(OwSensorType.DS18B20).get(0).getFullPath());
                properties.put(PROPERTY_DS2413, ds2438configuration.getAssociatedSensorIds(OwSensorType.DS2413).get(0).getFullPath());
                properties.put(PROPERTY_DS2438, ds2438configuration.getAssociatedSensorIds(OwSensorType.MS_TV).get(0).getFullPath());
                break;
            }
            default: {
                throw new OwException("sensorType " + this.sensorType.toString() + " not supported by this thing handler");
            }
        }
        return properties;
    }

    private static Set<String> getRequiredProperties(ThingTypeUID thingType) {
        if (OwBindingConstants.THING_TYPE_AMS.equals((Object)thingType)) {
            return REQUIRED_PROPERTIES_AMS;
        }
        return REQUIRED_PROPERTIES_BMS;
    }
}

