/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal.handler;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.onewire.internal.DS2438Configuration;
import org.eclipse.smarthome.binding.onewire.internal.OwBindingConstants;
import org.eclipse.smarthome.binding.onewire.internal.OwDynamicStateDescriptionProvider;
import org.eclipse.smarthome.binding.onewire.internal.OwException;
import org.eclipse.smarthome.binding.onewire.internal.device.AbstractOwDevice;
import org.eclipse.smarthome.binding.onewire.internal.device.DS1923;
import org.eclipse.smarthome.binding.onewire.internal.device.DS2438;
import org.eclipse.smarthome.binding.onewire.internal.device.OwSensorType;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseBridgeHandler;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseThingHandler;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.builder.ThingBuilder;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;

@NonNullByDefault
public class BasicMultisensorThingHandler
extends OwBaseThingHandler {
    public static final Set<ThingTypeUID> SUPPORTED_THING_TYPES = Collections.unmodifiableSet(Stream.of(OwBindingConstants.THING_TYPE_MS_TX, OwBindingConstants.THING_TYPE_MS_TH, OwBindingConstants.THING_TYPE_MS_TV).collect(Collectors.toSet()));
    public static final Set<OwSensorType> SUPPORTED_SENSOR_TYPES = Collections.unmodifiableSet(Stream.of(OwSensorType.MS_TH, OwSensorType.MS_TC, OwSensorType.MS_TL, OwSensorType.MS_TV, OwSensorType.DS1923, OwSensorType.DS2438).collect(Collectors.toSet()));

    public BasicMultisensorThingHandler(Thing thing, OwDynamicStateDescriptionProvider dynamicStateDescriptionProvider) {
        super(thing, dynamicStateDescriptionProvider, SUPPORTED_SENSOR_TYPES);
    }

    @Override
    public void initialize() {
        if (!this.thing.getThingTypeUID().equals((Object)OwBindingConstants.THING_TYPE_MS_TX)) {
            this.changeThingType(OwBindingConstants.THING_TYPE_MS_TX, this.getConfig());
        }
        if (!super.configure()) {
            return;
        }
        if (this.sensorType == OwSensorType.DS1923) {
            this.sensors.add(new DS1923(this.sensorId, this));
        } else {
            this.sensors.add(new DS2438(this.sensorId, this));
        }
        this.scheduler.execute(() -> this.configureThingChannels());
    }

    private void configureThingChannels() {
        ThingBuilder thingBuilder = this.editThing();
        ((AbstractOwDevice)this.sensors.get(0)).enableChannel("temperature");
        if (this.sensorType == OwSensorType.DS1923) {
            this.removeChannelIfExisting(thingBuilder, "supplyvoltage");
        } else {
            this.addChannelIfMissing(thingBuilder, "supplyvoltage", OwBindingConstants.CHANNEL_TYPE_UID_VOLTAGE, "Supply Voltage");
            ((AbstractOwDevice)this.sensors.get(0)).enableChannel("supplyvoltage");
        }
        switch (this.sensorType) {
            case DS2438: {
                this.addChannelIfMissing(thingBuilder, "voltage", OwBindingConstants.CHANNEL_TYPE_UID_VOLTAGE);
                this.addChannelIfMissing(thingBuilder, "current", OwBindingConstants.CHANNEL_TYPE_UID_CURRENT);
                this.removeChannelIfExisting(thingBuilder, "humidity");
                this.removeChannelIfExisting(thingBuilder, "absolutehumidity");
                this.removeChannelIfExisting(thingBuilder, "dewpoint");
                this.removeChannelIfExisting(thingBuilder, "light");
                ((DS2438)this.sensors.get(0)).setCurrentSensorType(DS2438.CurrentSensorType.INTERNAL);
                ((AbstractOwDevice)this.sensors.get(0)).enableChannel("voltage");
                ((AbstractOwDevice)this.sensors.get(0)).enableChannel("current");
                break;
            }
            case DS1923: {
                this.addChannelIfMissing(thingBuilder, "humidity", OwBindingConstants.CHANNEL_TYPE_UID_HUMIDITY);
                this.addChannelIfMissing(thingBuilder, "absolutehumidity", OwBindingConstants.CHANNEL_TYPE_UID_ABSHUMIDITY);
                this.addChannelIfMissing(thingBuilder, "dewpoint", OwBindingConstants.CHANNEL_TYPE_UID_DEWPOINT);
                this.removeChannelIfExisting(thingBuilder, "light");
                this.removeChannelIfExisting(thingBuilder, "current");
                this.removeChannelIfExisting(thingBuilder, "voltage");
                ((AbstractOwDevice)this.sensors.get(0)).enableChannel("humidity");
                ((AbstractOwDevice)this.sensors.get(0)).enableChannel("absolutehumidity");
                ((AbstractOwDevice)this.sensors.get(0)).enableChannel("dewpoint");
                break;
            }
            case MS_TC: {
                this.addChannelIfMissing(thingBuilder, "current", OwBindingConstants.CHANNEL_TYPE_UID_CURRENT);
                this.removeChannelIfExisting(thingBuilder, "humidity");
                this.removeChannelIfExisting(thingBuilder, "absolutehumidity");
                this.removeChannelIfExisting(thingBuilder, "dewpoint");
                this.removeChannelIfExisting(thingBuilder, "light");
                this.removeChannelIfExisting(thingBuilder, "voltage");
                ((DS2438)this.sensors.get(0)).setCurrentSensorType(DS2438.CurrentSensorType.IBUTTONLINK);
                ((AbstractOwDevice)this.sensors.get(0)).enableChannel("current");
                break;
            }
            case MS_TH: {
                this.addChannelIfMissing(thingBuilder, "humidity", OwBindingConstants.CHANNEL_TYPE_UID_HUMIDITYCONF);
                this.addChannelIfMissing(thingBuilder, "absolutehumidity", OwBindingConstants.CHANNEL_TYPE_UID_ABSHUMIDITY);
                this.addChannelIfMissing(thingBuilder, "dewpoint", OwBindingConstants.CHANNEL_TYPE_UID_DEWPOINT);
                this.removeChannelIfExisting(thingBuilder, "light");
                this.removeChannelIfExisting(thingBuilder, "voltage");
                this.removeChannelIfExisting(thingBuilder, "current");
                ((AbstractOwDevice)this.sensors.get(0)).enableChannel("humidity");
                ((AbstractOwDevice)this.sensors.get(0)).enableChannel("absolutehumidity");
                ((AbstractOwDevice)this.sensors.get(0)).enableChannel("dewpoint");
                break;
            }
            case MS_TL: {
                this.addChannelIfMissing(thingBuilder, "light", OwBindingConstants.CHANNEL_TYPE_UID_LIGHT);
                this.removeChannelIfExisting(thingBuilder, "humidity");
                this.removeChannelIfExisting(thingBuilder, "absolutehumidity");
                this.removeChannelIfExisting(thingBuilder, "dewpoint");
                this.removeChannelIfExisting(thingBuilder, "current");
                this.removeChannelIfExisting(thingBuilder, "voltage");
                ((AbstractOwDevice)this.sensors.get(0)).enableChannel("light");
                ((DS2438)this.sensors.get(0)).setLightSensorType(DS2438.LightSensorType.IBUTTONLINK);
                break;
            }
            default: {
                this.addChannelIfMissing(thingBuilder, "voltage", OwBindingConstants.CHANNEL_TYPE_UID_VOLTAGE);
                this.removeChannelIfExisting(thingBuilder, "humidity");
                this.removeChannelIfExisting(thingBuilder, "absolutehumidity");
                this.removeChannelIfExisting(thingBuilder, "dewpoint");
                this.removeChannelIfExisting(thingBuilder, "current");
                this.removeChannelIfExisting(thingBuilder, "light");
                ((AbstractOwDevice)this.sensors.get(0)).enableChannel("voltage");
            }
        }
        this.updateThing(thingBuilder.build());
        try {
            ((AbstractOwDevice)this.sensors.get(0)).configureChannels();
        }
        catch (OwException e) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, e.getMessage());
            return;
        }
        this.validConfig = true;
        this.updatePresenceStatus((State)UnDefType.UNDEF);
    }

    @Override
    public Map<String, String> updateSensorProperties(OwBaseBridgeHandler bridgeHandler) throws OwException {
        HashMap<String, String> properties = new HashMap<String, String>();
        this.sensorType = bridgeHandler.getType(this.sensorId);
        if (this.sensorType == OwSensorType.DS1923) {
            properties.put("modelId", this.sensorType.toString());
            properties.put("vendor", "Dallas/Maxim");
        } else {
            DS2438Configuration ds2438configuration = new DS2438Configuration(bridgeHandler, this.sensorId);
            this.sensorType = ds2438configuration.getSensorSubType();
            properties.put("modelId", this.sensorType.toString());
            String vendor = ds2438configuration.getVendor();
            properties.put("vendor", vendor);
        }
        return properties;
    }
}

