/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal.handler;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.onewire.internal.OwBindingConstants;
import org.eclipse.smarthome.binding.onewire.internal.OwDynamicStateDescriptionProvider;
import org.eclipse.smarthome.binding.onewire.internal.OwException;
import org.eclipse.smarthome.binding.onewire.internal.device.AbstractOwDevice;
import org.eclipse.smarthome.binding.onewire.internal.device.DS18x20;
import org.eclipse.smarthome.binding.onewire.internal.device.OwSensorType;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseThingHandler;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.builder.ThingBuilder;

@NonNullByDefault
public class TemperatureSensorThingHandler
extends OwBaseThingHandler {
    public static final Set<ThingTypeUID> SUPPORTED_THING_TYPES = Collections.singleton(OwBindingConstants.THING_TYPE_TEMPERATURE);
    public static final Set<OwSensorType> SUPPORTED_SENSOR_TYPES = Collections.unmodifiableSet(Stream.of(OwSensorType.DS18B20, OwSensorType.DS18S20, OwSensorType.DS1822).collect(Collectors.toSet()));

    public TemperatureSensorThingHandler(Thing thing, OwDynamicStateDescriptionProvider dynamicStateDescriptionProvider) {
        super(thing, dynamicStateDescriptionProvider, SUPPORTED_SENSOR_TYPES);
    }

    @Override
    public void initialize() {
        if (!super.configure()) {
            return;
        }
        this.sensors.add(new DS18x20(this.sensorId, this));
        this.scheduler.execute(() -> this.configureThingChannels());
    }

    private void configureThingChannels() {
        Channel tempChannel = this.thing.getChannel("temperature");
        if (tempChannel == null) {
            Map properties = this.editProperties();
            ThingBuilder thingBuilder = this.editThing();
            if (((String)properties.get("modelId")).equals("DS18B20") || ((String)properties.get("modelId")).equals("DS1822")) {
                this.addChannelIfMissing(thingBuilder, "temperature", OwBindingConstants.CHANNEL_TYPE_UID_TEMPERATURE_POR_RES);
            } else {
                this.addChannelIfMissing(thingBuilder, "temperature", OwBindingConstants.CHANNEL_TYPE_UID_TEMPERATURE_POR);
            }
            this.updateThing(thingBuilder.build());
        }
        try {
            ((AbstractOwDevice)this.sensors.get(0)).configureChannels();
            ((AbstractOwDevice)this.sensors.get(0)).enableChannel("temperature");
        }
        catch (OwException e) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, e.getMessage());
            return;
        }
        this.validConfig = true;
        this.updateStatus(ThingStatus.UNKNOWN, ThingStatusDetail.NONE);
    }
}

