/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal.owserver;

import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault
public enum OwserverTemperatureScale {
    CENTIGRADE(0),
    FAHRENHEIT(65536),
    KELVIN(131072),
    RANKINE(196608);

    private static final int CLEAR_MASK = 196608;
    private final int flag;

    private OwserverTemperatureScale(int flag) {
        this.flag = flag;
    }

    public int getValue() {
        return this.flag;
    }

    public int setFlag(int flags) {
        int tempFlags = flags;
        tempFlags &= 0xFFFCFFFF;
        return tempFlags |= this.getValue();
    }

    public static OwserverTemperatureScale getFlag(int flags) {
        int tempFlags = flags;
        tempFlags &= 0x30000;
        OwserverTemperatureScale[] owserverTemperatureScaleArray = OwserverTemperatureScale.values();
        int n = owserverTemperatureScaleArray.length;
        int n2 = 0;
        while (n2 < n) {
            OwserverTemperatureScale value = owserverTemperatureScaleArray[n2];
            if (value.getValue() == tempFlags) {
                return value;
            }
            ++n2;
        }
        return CENTIGRADE;
    }
}

