/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.sonyaudio.internal;

import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.smarthome.binding.sonyaudio.SonyAudioBindingConstants;
import org.eclipse.smarthome.binding.sonyaudio.handler.HtCt800Handler;
import org.eclipse.smarthome.binding.sonyaudio.handler.HtMt500Handler;
import org.eclipse.smarthome.binding.sonyaudio.handler.HtSt5000Handler;
import org.eclipse.smarthome.binding.sonyaudio.handler.HtZ9fHandler;
import org.eclipse.smarthome.binding.sonyaudio.handler.HtZf9Handler;
import org.eclipse.smarthome.binding.sonyaudio.handler.SrsZr5Handler;
import org.eclipse.smarthome.binding.sonyaudio.handler.StrDn1080Handler;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandlerFactory;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerFactory;
import org.eclipse.smarthome.io.net.http.WebSocketFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ThingHandlerFactory.class}, configurationPid="binding.sonyaudio")
public class SonyAudioHandlerFactory
extends BaseThingHandlerFactory {
    private WebSocketClient webSocketClient;

    public boolean supportsThingType(ThingTypeUID thingTypeUID) {
        return SonyAudioBindingConstants.SUPPORTED_THING_TYPES_UIDS.contains(thingTypeUID);
    }

    protected ThingHandler createHandler(Thing thing) {
        ThingTypeUID thingTypeUID = thing.getThingTypeUID();
        switch (thingTypeUID.getId()) {
            case "STR-DN1080": {
                return new StrDn1080Handler(thing, this.webSocketClient);
            }
            case "HT-CT800": {
                return new HtCt800Handler(thing, this.webSocketClient);
            }
            case "HT-ST5000": {
                return new HtSt5000Handler(thing, this.webSocketClient);
            }
            case "HT-Z9F": {
                return new HtZ9fHandler(thing, this.webSocketClient);
            }
            case "HT-ZF9": {
                return new HtZf9Handler(thing, this.webSocketClient);
            }
            case "HT-MT500": {
                return new HtMt500Handler(thing, this.webSocketClient);
            }
            case "SRS-ZR5": {
                return new SrsZr5Handler(thing, this.webSocketClient);
            }
        }
        return null;
    }

    @Reference
    protected void setWebSocketFactory(WebSocketFactory webSocketFactory) {
        this.webSocketClient = webSocketFactory.getCommonWebSocketClient();
    }

    protected void unsetWebSocketFactory(WebSocketFactory webSocketFactory) {
        this.webSocketClient = null;
    }
}

