/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.tradfri.handler;

import com.google.gson.JsonElement;
import org.eclipse.smarthome.binding.tradfri.handler.TradfriThingHandler;
import org.eclipse.smarthome.binding.tradfri.internal.model.TradfriPlugData;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TradfriPlugHandler
extends TradfriThingHandler {
    private final Logger logger = LoggerFactory.getLogger(TradfriPlugHandler.class);

    public TradfriPlugHandler(Thing thing) {
        super(thing);
    }

    @Override
    public void onUpdate(JsonElement data) {
        if (this.active && !data.isJsonNull()) {
            TradfriPlugData state = new TradfriPlugData(data);
            this.updateStatus(state.getReachabilityStatus() ? ThingStatus.ONLINE : ThingStatus.OFFLINE);
            this.updateState("power", (State)(state.getOnOffState() ? OnOffType.ON : OnOffType.OFF));
            this.updateDeviceProperties(state);
        }
    }

    private void setState(OnOffType onOff) {
        TradfriPlugData data = new TradfriPlugData();
        data.setOnOffState(onOff == OnOffType.ON);
        this.set(data.getJsonString());
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
        block9: {
            if (!this.active) break block9;
            if (command instanceof RefreshType) {
                this.logger.debug("Refreshing channel {}", (Object)channelUID);
                this.coapClient.asyncGet(this);
                return;
            }
            switch (channelUID.getId()) {
                case "power": {
                    if (command instanceof OnOffType) {
                        this.setState((OnOffType)command);
                        break;
                    }
                    this.logger.debug("Cannot handle command '{}' for channel '{}'", (Object)command, (Object)"power");
                    break;
                }
                default: {
                    this.logger.error("Unknown channel UID {}", (Object)channelUID);
                }
            }
        }
    }
}

