/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.tradfri.internal.model;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class TradfriVersion
implements Comparable<TradfriVersion> {
    private static final String VERSION_PATTERN = "[0-9]+(\\.[0-9]+)*";
    private static final String VERSION_DELIMITER = "\\.";
    final List<Integer> parts;

    public TradfriVersion(String version) {
        if (!version.matches(VERSION_PATTERN)) {
            throw new IllegalArgumentException("TradfriVersion cannot be created as version has invalid format.");
        }
        this.parts = Arrays.stream(version.split(VERSION_DELIMITER)).map(part -> Integer.parseInt(part)).collect(Collectors.toList());
    }

    @Override
    public int compareTo(TradfriVersion other) {
        int minSize = Math.min(this.parts.size(), other.parts.size());
        int i = 0;
        while (i < minSize) {
            int diff = this.parts.get(i) - other.parts.get(i);
            if (diff != 0) {
                if (diff < 0) {
                    return -1;
                }
                return 1;
            }
            ++i;
        }
        i = minSize;
        while (i < this.parts.size()) {
            if (this.parts.get(i) != 0) {
                return 1;
            }
            ++i;
        }
        i = minSize;
        while (i < other.parts.size()) {
            if (other.parts.get(i) != 0) {
                return -1;
            }
            ++i;
        }
        return 0;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.compareTo((TradfriVersion)obj) == 0;
    }

    public String toString() {
        return this.parts.stream().map(String::valueOf).collect(Collectors.joining("."));
    }
}

