/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core.status;

import java.util.Arrays;
import java.util.Objects;

public final class ConfigStatusMessage {
    public final String parameterName;
    public final Type type;
    final transient String messageKey;
    final transient Object[] arguments;
    public final String message;
    public final Integer statusCode;

    private ConfigStatusMessage(Builder builder) {
        this.parameterName = builder.parameterName;
        this.type = builder.type;
        this.messageKey = builder.messageKey;
        this.arguments = builder.arguments;
        this.message = null;
        this.statusCode = builder.statusCode;
    }

    ConfigStatusMessage(String parameterName, Type type, String message, Integer statusCode) {
        this(parameterName, type, null, null, message, statusCode);
    }

    private ConfigStatusMessage(String parameterName, Type type, String messageKey, Object[] arguments, String message, Integer statusCode) {
        this.parameterName = parameterName;
        this.type = type;
        this.messageKey = messageKey;
        this.arguments = arguments;
        this.message = message;
        this.statusCode = statusCode;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.parameterName == null ? 0 : this.parameterName.hashCode());
        result = 31 * result + (this.statusCode == null ? 0 : this.statusCode.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigStatusMessage other = (ConfigStatusMessage)obj;
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.parameterName == null ? other.parameterName != null : !this.parameterName.equals(other.parameterName)) {
            return false;
        }
        if (this.statusCode == null ? other.statusCode != null : !this.statusCode.equals(other.statusCode)) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        return "ConfigStatusMessage [parameterName=" + this.parameterName + ", type=" + (Object)((Object)this.type) + ", messageKey=" + this.messageKey + ", arguments=" + Arrays.toString(this.arguments) + ", message=" + this.message + ", statusCode=" + this.statusCode + "]";
    }

    /* synthetic */ ConfigStatusMessage(Builder builder, ConfigStatusMessage configStatusMessage) {
        this(builder);
    }

    public static class Builder {
        private static final String CONFIG_STATUS_MSG_KEY_PREFIX = "config-status.";
        private final String parameterName;
        private final Type type;
        private String messageKey;
        private Object[] arguments;
        private Integer statusCode;

        private Builder(String parameterName, Type type) {
            Objects.requireNonNull(parameterName, "Parameter name must not be null.");
            Objects.requireNonNull(type, "Type must not be null.");
            this.parameterName = parameterName;
            this.type = type;
        }

        public static Builder information(String parameterName) {
            return new Builder(parameterName, Type.INFORMATION);
        }

        public static Builder warning(String parameterName) {
            return new Builder(parameterName, Type.WARNING);
        }

        public static Builder error(String parameterName) {
            return new Builder(parameterName, Type.ERROR);
        }

        public static Builder pending(String parameterName) {
            return new Builder(parameterName, Type.PENDING);
        }

        public Builder withArguments(Object ... arguments) {
            this.arguments = arguments;
            return this;
        }

        public Builder withStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder withMessageKeySuffix(String messageKeySuffix) {
            this.messageKey = CONFIG_STATUS_MSG_KEY_PREFIX + this.type.name().toLowerCase() + "." + messageKeySuffix;
            return this;
        }

        public ConfigStatusMessage build() {
            return new ConfigStatusMessage(this, null);
        }
    }

    public static enum Type {
        INFORMATION,
        WARNING,
        ERROR,
        PENDING;

    }
}

