/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.discovery.usbserial.internal;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.config.discovery.AbstractDiscoveryService;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryService;
import org.eclipse.smarthome.config.discovery.usbserial.UsbSerialDeviceInformation;
import org.eclipse.smarthome.config.discovery.usbserial.UsbSerialDiscovery;
import org.eclipse.smarthome.config.discovery.usbserial.UsbSerialDiscoveryListener;
import org.eclipse.smarthome.config.discovery.usbserial.UsbSerialDiscoveryParticipant;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, service={DiscoveryService.class, UsbSerialDiscoveryService.class}, configurationPid="discovery.usbserial")
public class UsbSerialDiscoveryService
extends AbstractDiscoveryService
implements UsbSerialDiscoveryListener {
    private final Logger logger = LoggerFactory.getLogger(UsbSerialDiscoveryService.class);
    private final Set<UsbSerialDiscoveryParticipant> discoveryParticipants = new CopyOnWriteArraySet<UsbSerialDiscoveryParticipant>();
    private final Set<UsbSerialDeviceInformation> previouslyDiscovered = new CopyOnWriteArraySet<UsbSerialDeviceInformation>();
    @NonNullByDefault(value={})
    private UsbSerialDiscovery usbSerialDiscovery;

    public UsbSerialDiscoveryService() {
        super(5);
    }

    @Activate
    protected void activate(@Nullable Map<String, @Nullable Object> configProperties) {
        super.activate(configProperties);
        this.usbSerialDiscovery.registerDiscoveryListener(this);
    }

    @Modified
    protected void modified(@Nullable Map<@NonNull String, @Nullable Object> configProperties) {
        super.modified(configProperties);
    }

    @Deactivate
    protected void deactivate() {
        super.deactivate();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addUsbSerialDiscoveryParticipant(UsbSerialDiscoveryParticipant participant) {
        this.discoveryParticipants.add(participant);
        for (UsbSerialDeviceInformation usbSerialDeviceInformation : this.previouslyDiscovered) {
            DiscoveryResult result = participant.createResult(usbSerialDeviceInformation);
            if (result == null) continue;
            this.thingDiscovered(result);
        }
    }

    protected void removeUsbSerialDiscoveryParticipant(UsbSerialDiscoveryParticipant participant) {
        this.discoveryParticipants.remove(participant);
    }

    @Reference
    protected void setUsbSerialDiscovery(UsbSerialDiscovery usbSerialDiscovery) {
        this.usbSerialDiscovery = usbSerialDiscovery;
    }

    protected synchronized void unsetUsbSerialDiscovery(UsbSerialDiscovery usbSerialDiscovery) {
        usbSerialDiscovery.stopBackgroundScanning();
        usbSerialDiscovery.unregisterDiscoveryListener(this);
        this.usbSerialDiscovery = null;
        this.previouslyDiscovered.clear();
    }

    public Set<ThingTypeUID> getSupportedThingTypes() {
        return this.discoveryParticipants.stream().flatMap(participant -> participant.getSupportedThingTypeUIDs().stream()).collect(Collectors.toSet());
    }

    protected void startScan() {
        if (this.usbSerialDiscovery != null) {
            this.usbSerialDiscovery.doSingleScan();
        } else {
            this.logger.info("Could not scan, as there is no USB-Serial discovery service configured.");
        }
    }

    protected void startBackgroundDiscovery() {
        if (this.usbSerialDiscovery != null) {
            this.usbSerialDiscovery.startBackgroundScanning();
        } else {
            this.logger.info("Could not start background discovery, as there is no USB-Serial discovery service configured.");
        }
    }

    protected void stopBackgroundDiscovery() {
        if (this.usbSerialDiscovery != null) {
            this.usbSerialDiscovery.stopBackgroundScanning();
        } else {
            this.logger.info("Could not stop background discovery, as there is no USB-Serial discovery service configured.");
        }
    }

    @Override
    public void usbSerialDeviceDiscovered(UsbSerialDeviceInformation usbSerialDeviceInformation) {
        this.logger.debug("Discovered new USB-Serial device: {}", (Object)usbSerialDeviceInformation);
        this.previouslyDiscovered.add(usbSerialDeviceInformation);
        for (UsbSerialDiscoveryParticipant participant : this.discoveryParticipants) {
            DiscoveryResult result = participant.createResult(usbSerialDeviceInformation);
            if (result == null) continue;
            this.thingDiscovered(result);
        }
    }

    @Override
    public void usbSerialDeviceRemoved(UsbSerialDeviceInformation usbSerialDeviceInformation) {
        this.logger.debug("Discovered removed USB-Serial device: {}", (Object)usbSerialDeviceInformation);
        this.previouslyDiscovered.remove(usbSerialDeviceInformation);
        for (UsbSerialDiscoveryParticipant participant : this.discoveryParticipants) {
            ThingUID thingUID = participant.getThingUID(usbSerialDeviceInformation);
            if (thingUID == null) continue;
            this.thingRemoved(thingUID);
        }
    }
}

