/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.discovery.internal;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryResultFlag;
import org.eclipse.smarthome.config.discovery.inbox.Inbox;
import org.eclipse.smarthome.config.discovery.inbox.InboxAutoApprovePredicate;
import org.eclipse.smarthome.config.discovery.inbox.InboxListener;
import org.eclipse.smarthome.config.discovery.inbox.InboxPredicates;
import org.eclipse.smarthome.core.common.registry.RegistryChangeListener;
import org.eclipse.smarthome.core.events.AbstractTypedEventSubscriber;
import org.eclipse.smarthome.core.events.EventSubscriber;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.events.ThingStatusInfoChangedEvent;
import org.eclipse.smarthome.core.thing.type.ThingType;
import org.eclipse.smarthome.core.thing.type.ThingTypeRegistry;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, configurationPid="org.eclipse.smarthome.inbox", service={EventSubscriber.class}, property={"service.config.description.uri=system:inbox", "service.config.label=Inbox", "service.config.category=system", "service.pid=org.eclipse.smarthome.inbox"})
@NonNullByDefault
public class AutomaticInboxProcessor
extends AbstractTypedEventSubscriber<ThingStatusInfoChangedEvent>
implements InboxListener,
RegistryChangeListener<Thing> {
    public static final String AUTO_IGNORE_CONFIG_PROPERTY = "autoIgnore";
    public static final String ALWAYS_AUTO_APPROVE_CONFIG_PROPERTY = "autoApprove";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NonNullByDefault(value={})
    private ThingRegistry thingRegistry;
    @NonNullByDefault(value={})
    private ThingTypeRegistry thingTypeRegistry;
    @NonNullByDefault(value={})
    private Inbox inbox;
    private boolean autoIgnore = true;
    private boolean alwaysAutoApprove = false;
    private final Set<InboxAutoApprovePredicate> inboxAutoApprovePredicates = new CopyOnWriteArraySet<InboxAutoApprovePredicate>();

    public AutomaticInboxProcessor() {
        super(ThingStatusInfoChangedEvent.TYPE);
    }

    public void receiveTypedEvent(ThingStatusInfoChangedEvent event) {
        if (this.autoIgnore) {
            Thing thing = this.thingRegistry.get(event.getThingUID());
            ThingStatus thingStatus = event.getStatusInfo().getStatus();
            this.autoIgnore(thing, thingStatus);
        }
    }

    @Override
    public void thingAdded(Inbox inbox, DiscoveryResult result) {
        Thing thing;
        String value;
        if (this.autoIgnore && (value = this.getRepresentationValue(result)) != null && (thing = (Thing)this.thingRegistry.stream().filter(t -> Objects.equals(value, this.getRepresentationPropertyValueForThing((Thing)t))).filter(t -> Objects.equals(t.getThingTypeUID(), result.getThingTypeUID())).findFirst().orElse(null)) != null) {
            this.logger.debug("Auto-ignoring the inbox entry for the representation value {}", (Object)value);
            inbox.setFlag(result.getThingUID(), DiscoveryResultFlag.IGNORED);
        }
        if (this.alwaysAutoApprove || this.isToBeAutoApproved(result)) {
            inbox.approve(result.getThingUID(), result.getLabel());
        }
    }

    @Override
    public void thingUpdated(Inbox inbox, DiscoveryResult result) {
    }

    @Override
    public void thingRemoved(Inbox inbox, DiscoveryResult result) {
    }

    public void added(Thing element) {
    }

    public void removed(Thing element) {
        this.removePossiblyIgnoredResultInInbox(element);
    }

    public void updated(Thing oldElement, Thing element) {
    }

    private @Nullable String getRepresentationValue(DiscoveryResult result) {
        return result.getRepresentationProperty() != null ? Objects.toString(result.getProperties().get(result.getRepresentationProperty()), null) : null;
    }

    private void autoIgnore(@Nullable Thing thing, ThingStatus thingStatus) {
        if (ThingStatus.ONLINE.equals((Object)thingStatus)) {
            this.checkAndIgnoreInInbox(thing);
        }
    }

    private void checkAndIgnoreInInbox(@Nullable Thing thing) {
        String representationValue;
        if (thing != null && (representationValue = this.getRepresentationPropertyValueForThing(thing)) != null) {
            this.ignoreInInbox(thing.getThingTypeUID(), representationValue);
        }
    }

    private void ignoreInInbox(ThingTypeUID thingtypeUID, String representationValue) {
        List results = this.inbox.stream().filter(InboxPredicates.withRepresentationPropertyValue(representationValue)).filter(InboxPredicates.forThingTypeUID(thingtypeUID)).collect(Collectors.toList());
        if (results.size() == 1) {
            this.logger.debug("Auto-ignoring the inbox entry for the representation value {}", (Object)representationValue);
            this.inbox.setFlag(((DiscoveryResult)results.get(0)).getThingUID(), DiscoveryResultFlag.IGNORED);
        }
    }

    private void removePossiblyIgnoredResultInInbox(@Nullable Thing thing) {
        String representationValue;
        if (thing != null && (representationValue = this.getRepresentationPropertyValueForThing(thing)) != null) {
            this.removeFromInbox(thing.getThingTypeUID(), representationValue);
        }
    }

    private @Nullable String getRepresentationPropertyValueForThing(Thing thing) {
        ThingType thingType = this.thingTypeRegistry.getThingType(thing.getThingTypeUID());
        if (thingType != null) {
            String representationProperty = thingType.getRepresentationProperty();
            if (representationProperty == null) {
                return null;
            }
            Map properties = thing.getProperties();
            if (properties.containsKey(representationProperty)) {
                return (String)properties.get(representationProperty);
            }
            Configuration configuration = thing.getConfiguration();
            if (configuration.containsKey(representationProperty)) {
                return String.valueOf(configuration.get(representationProperty));
            }
        }
        return null;
    }

    private void removeFromInbox(ThingTypeUID thingtypeUID, String representationValue) {
        List results = this.inbox.stream().filter(InboxPredicates.withRepresentationPropertyValue(representationValue)).filter(InboxPredicates.forThingTypeUID(thingtypeUID)).filter(InboxPredicates.withFlag(DiscoveryResultFlag.IGNORED)).collect(Collectors.toList());
        if (results.size() == 1) {
            this.logger.debug("Removing the ignored result from the inbox for the representation value {}", (Object)representationValue);
            this.inbox.remove(((DiscoveryResult)results.get(0)).getThingUID());
        }
    }

    private void autoApproveInboxEntries() {
        for (DiscoveryResult result : this.inbox.getAll()) {
            if (!result.getFlag().equals((Object)DiscoveryResultFlag.NEW) || !this.alwaysAutoApprove && !this.isToBeAutoApproved(result)) continue;
            this.inbox.approve(result.getThingUID(), result.getLabel());
        }
    }

    private boolean isToBeAutoApproved(DiscoveryResult result) {
        return this.inboxAutoApprovePredicates.stream().anyMatch(predicate -> predicate.test(result));
    }

    protected void activate(@Nullable Map<String, @Nullable Object> properties) {
        if (properties != null) {
            Object value = properties.get(AUTO_IGNORE_CONFIG_PROPERTY);
            this.autoIgnore = value == null || !value.toString().equals("false");
            value = properties.get(ALWAYS_AUTO_APPROVE_CONFIG_PROPERTY);
            this.alwaysAutoApprove = value != null && value.toString().equals("true");
            this.autoApproveInboxEntries();
        }
    }

    @Reference
    protected void setThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = thingRegistry;
        thingRegistry.addRegistryChangeListener((RegistryChangeListener)this);
    }

    protected void unsetThingRegistry(ThingRegistry thingRegistry) {
        thingRegistry.removeRegistryChangeListener((RegistryChangeListener)this);
        this.thingRegistry = null;
    }

    @Reference
    protected void setThingTypeRegistry(ThingTypeRegistry thingTypeRegistry) {
        this.thingTypeRegistry = thingTypeRegistry;
    }

    protected void unsetThingTypeRegistry(ThingTypeRegistry thingTypeRegistry) {
        this.thingTypeRegistry = null;
    }

    @Reference
    protected void setInbox(Inbox inbox) {
        this.inbox = inbox;
        inbox.addInboxListener(this);
    }

    protected void unsetInbox(Inbox inbox) {
        inbox.removeInboxListener(this);
        this.inbox = null;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addInboxAutoApprovePredicate(InboxAutoApprovePredicate inboxAutoApprovePredicate) {
        this.inboxAutoApprovePredicates.add(inboxAutoApprovePredicate);
        for (DiscoveryResult result : this.inbox.getAll()) {
            if (!result.getFlag().equals((Object)DiscoveryResultFlag.NEW) || !inboxAutoApprovePredicate.test(result)) continue;
            this.inbox.approve(result.getThingUID(), result.getLabel());
        }
    }

    protected void removeInboxAutoApprovePredicate(InboxAutoApprovePredicate inboxAutoApprovePredicate) {
        this.inboxAutoApprovePredicates.remove(inboxAutoApprovePredicate);
    }
}

