/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.audio;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.smarthome.core.audio.AudioFormat;
import org.eclipse.smarthome.core.audio.FixedLengthAudioStream;

public class ByteArrayAudioStream
extends FixedLengthAudioStream {
    private byte[] bytes;
    private AudioFormat format;
    private ByteArrayInputStream stream;

    public ByteArrayAudioStream(byte[] bytes, AudioFormat format) {
        this.bytes = bytes;
        this.format = format;
        this.stream = new ByteArrayInputStream(bytes);
    }

    @Override
    public AudioFormat getFormat() {
        return this.format;
    }

    @Override
    public int read() throws IOException {
        return this.stream.read();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public long length() {
        return this.bytes.length;
    }

    @Override
    public InputStream getClonedStream() {
        return new ByteArrayAudioStream(this.bytes, this.format);
    }
}

