/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.audio.internal;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.eclipse.smarthome.config.core.ConfigConstants;
import org.eclipse.smarthome.config.core.ConfigOptionProvider;
import org.eclipse.smarthome.config.core.ParameterOption;
import org.eclipse.smarthome.core.audio.AudioException;
import org.eclipse.smarthome.core.audio.AudioManager;
import org.eclipse.smarthome.core.audio.AudioSink;
import org.eclipse.smarthome.core.audio.AudioSource;
import org.eclipse.smarthome.core.audio.AudioStream;
import org.eclipse.smarthome.core.audio.FileAudioStream;
import org.eclipse.smarthome.core.audio.URLAudioStream;
import org.eclipse.smarthome.core.audio.UnsupportedAudioFormatException;
import org.eclipse.smarthome.core.audio.UnsupportedAudioStreamException;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, configurationPid="org.eclipse.smarthome.audio", property={"service.pid=org.eclipse.smarthome.audio", "service.config.category=system", "service.config.description.uri=system:audio", "service.config.label=Audio"})
public class AudioManagerImpl
implements AudioManager,
ConfigOptionProvider {
    static final String CONFIG_URI = "system:audio";
    static final String CONFIG_DEFAULT_SINK = "defaultSink";
    static final String CONFIG_DEFAULT_SOURCE = "defaultSource";
    private final Logger logger = LoggerFactory.getLogger(AudioManagerImpl.class);
    private final Map<String, AudioSource> audioSources = new ConcurrentHashMap<String, AudioSource>();
    private final Map<String, AudioSink> audioSinks = new ConcurrentHashMap<String, AudioSink>();
    private String defaultSource;
    private String defaultSink;

    @Activate
    protected void activate(Map<String, Object> config) {
        this.modified(config);
    }

    @Deactivate
    protected void deactivate() {
    }

    @Modified
    void modified(Map<String, Object> config) {
        if (config != null) {
            this.defaultSource = config.containsKey(CONFIG_DEFAULT_SOURCE) ? config.get(CONFIG_DEFAULT_SOURCE).toString() : null;
            this.defaultSink = config.containsKey(CONFIG_DEFAULT_SINK) ? config.get(CONFIG_DEFAULT_SINK).toString() : null;
        }
    }

    @Override
    public void play(AudioStream audioStream) {
        this.play(audioStream, null);
    }

    @Override
    public void play(AudioStream audioStream, String sinkId) {
        this.play(audioStream, sinkId, null);
    }

    @Override
    public void play(AudioStream audioStream, String sinkId, PercentType volume) {
        block21: {
            AudioSink sink = this.getSink(sinkId);
            if (sink != null) {
                PercentType oldVolume = null;
                try {
                    oldVolume = this.getVolume(sinkId);
                }
                catch (IOException e) {
                    this.logger.debug("An exception occurred while getting the volume of sink '{}' : {}", new Object[]{sink.getId(), e.getMessage(), e});
                }
                if (volume != null) {
                    try {
                        this.setVolume(volume, sinkId);
                    }
                    catch (IOException e) {
                        this.logger.debug("An exception occurred while setting the volume of sink '{}' : {}", new Object[]{sink.getId(), e.getMessage(), e});
                    }
                }
                try {
                    try {
                        sink.process(audioStream);
                    }
                    catch (UnsupportedAudioFormatException | UnsupportedAudioStreamException e) {
                        this.logger.warn("Error playing '{}': {}", new Object[]{audioStream, e.getMessage(), e});
                        if (volume != null && oldVolume != null) {
                            try {
                                this.setVolume(oldVolume, sinkId);
                            }
                            catch (IOException e2) {
                                this.logger.debug("An exception occurred while setting the volume of sink '{}' : {}", new Object[]{sink.getId(), e2.getMessage(), e2});
                            }
                        }
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    if (volume != null && oldVolume != null) {
                        try {
                            this.setVolume(oldVolume, sinkId);
                        }
                        catch (IOException e) {
                            this.logger.debug("An exception occurred while setting the volume of sink '{}' : {}", new Object[]{sink.getId(), e.getMessage(), e});
                        }
                    }
                    throw throwable;
                }
                if (volume != null && oldVolume != null) {
                    try {
                        this.setVolume(oldVolume, sinkId);
                    }
                    catch (IOException e) {
                        this.logger.debug("An exception occurred while setting the volume of sink '{}' : {}", new Object[]{sink.getId(), e.getMessage(), e});
                    }
                }
            } else {
                this.logger.warn("Failed playing audio stream '{}' as no audio sink was found.", (Object)audioStream);
            }
        }
    }

    @Override
    public void playFile(String fileName) throws AudioException {
        this.playFile(fileName, null, null);
    }

    @Override
    public void playFile(String fileName, PercentType volume) throws AudioException {
        this.playFile(fileName, null, volume);
    }

    @Override
    public void playFile(String fileName, String sinkId) throws AudioException {
        this.playFile(fileName, sinkId, null);
    }

    @Override
    public void playFile(String fileName, String sinkId, PercentType volume) throws AudioException {
        Objects.requireNonNull(fileName, "File cannot be played as fileName is null.");
        File file = new File(String.valueOf(ConfigConstants.getConfigFolder()) + File.separator + "sounds" + File.separator + fileName);
        FileAudioStream is = new FileAudioStream(file);
        this.play(is, sinkId, volume);
    }

    @Override
    public void stream(String url) throws AudioException {
        this.stream(url, null);
    }

    @Override
    public void stream(String url, String sinkId) throws AudioException {
        URLAudioStream audioStream = url != null ? new URLAudioStream(url) : null;
        this.play(audioStream, sinkId, null);
    }

    @Override
    public PercentType getVolume(String sinkId) throws IOException {
        AudioSink sink = this.getSink(sinkId);
        if (sink != null) {
            return sink.getVolume();
        }
        return PercentType.ZERO;
    }

    @Override
    public void setVolume(PercentType volume, String sinkId) throws IOException {
        AudioSink sink = this.getSink(sinkId);
        if (sink != null) {
            sink.setVolume(volume);
        }
    }

    @Override
    public AudioSource getSource() {
        AudioSource source = null;
        if (this.defaultSource != null) {
            source = this.audioSources.get(this.defaultSource);
            if (source == null) {
                this.logger.warn("Default AudioSource service '{}' not available!", (Object)this.defaultSource);
            }
        } else if (!this.audioSources.isEmpty()) {
            source = this.audioSources.values().iterator().next();
        } else {
            this.logger.debug("No AudioSource service available!");
        }
        return source;
    }

    @Override
    public Set<AudioSource> getAllSources() {
        return new HashSet<AudioSource>(this.audioSources.values());
    }

    @Override
    public AudioSink getSink() {
        AudioSink sink = null;
        if (this.defaultSink != null) {
            sink = this.audioSinks.get(this.defaultSink);
            if (sink == null) {
                this.logger.warn("Default AudioSink service '{}' not available!", (Object)this.defaultSink);
            }
        } else if (!this.audioSinks.isEmpty()) {
            sink = this.audioSinks.values().iterator().next();
        } else {
            this.logger.debug("No AudioSink service available!");
        }
        return sink;
    }

    @Override
    public Set<AudioSink> getAllSinks() {
        return new HashSet<AudioSink>(this.audioSinks.values());
    }

    @Override
    public Set<String> getSourceIds(String pattern) {
        String regex = pattern.replace("?", ".?").replace("*", ".*?");
        HashSet<String> matchedSources = new HashSet<String>();
        for (String aSource : this.audioSources.keySet()) {
            if (!aSource.matches(regex)) continue;
            matchedSources.add(aSource);
        }
        return matchedSources;
    }

    @Override
    public AudioSink getSink(String sinkId) {
        return sinkId == null ? this.getSink() : this.audioSinks.get(sinkId);
    }

    @Override
    public Set<String> getSinkIds(String pattern) {
        String regex = pattern.replace("?", ".?").replace("*", ".*?");
        HashSet<String> matchedSinkIds = new HashSet<String>();
        for (String sinkId : this.audioSinks.keySet()) {
            if (!sinkId.matches(regex)) continue;
            matchedSinkIds.add(sinkId);
        }
        return matchedSinkIds;
    }

    public Collection<ParameterOption> getParameterOptions(URI uri, String param, Locale locale) {
        if (uri.toString().equals(CONFIG_URI)) {
            Locale safeLocale;
            Locale locale2 = safeLocale = locale != null ? locale : Locale.getDefault();
            if (CONFIG_DEFAULT_SOURCE.equals(param)) {
                return this.audioSources.values().stream().sorted(Comparator.comparing(s -> s.getLabel(safeLocale))).map(s -> new ParameterOption(s.getId(), s.getLabel(safeLocale))).collect(Collectors.toList());
            }
            if (CONFIG_DEFAULT_SINK.equals(param)) {
                return this.audioSinks.values().stream().sorted(Comparator.comparing(s -> s.getLabel(safeLocale))).map(s -> new ParameterOption(s.getId(), s.getLabel(safeLocale))).collect(Collectors.toList());
            }
        }
        return null;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addAudioSource(AudioSource audioSource) {
        this.audioSources.put(audioSource.getId(), audioSource);
    }

    protected void removeAudioSource(AudioSource audioSource) {
        this.audioSources.remove(audioSource.getId());
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addAudioSink(AudioSink audioSink) {
        this.audioSinks.put(audioSink.getId(), audioSink);
    }

    protected void removeAudioSink(AudioSink audioSink) {
        this.audioSinks.remove(audioSink.getId());
    }
}

