/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.binding.xml.internal;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.smarthome.config.core.ConfigDescriptionProvider;
import org.eclipse.smarthome.config.xml.AbstractXmlBasedProvider;
import org.eclipse.smarthome.config.xml.AbstractXmlConfigDescriptionProvider;
import org.eclipse.smarthome.config.xml.osgi.XmlDocumentBundleTracker;
import org.eclipse.smarthome.config.xml.osgi.XmlDocumentProvider;
import org.eclipse.smarthome.config.xml.osgi.XmlDocumentProviderFactory;
import org.eclipse.smarthome.config.xml.util.XmlDocumentReader;
import org.eclipse.smarthome.core.binding.BindingInfo;
import org.eclipse.smarthome.core.binding.BindingInfoProvider;
import org.eclipse.smarthome.core.binding.xml.internal.BindingInfoReader;
import org.eclipse.smarthome.core.binding.xml.internal.BindingInfoXmlProvider;
import org.eclipse.smarthome.core.binding.xml.internal.BindingInfoXmlResult;
import org.eclipse.smarthome.core.common.ThreadPoolManager;
import org.eclipse.smarthome.core.i18n.BindingI18nUtil;
import org.eclipse.smarthome.core.i18n.TranslationProvider;
import org.eclipse.smarthome.core.service.ReadyService;
import org.osgi.framework.Bundle;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component
public class XmlBindingInfoProvider
extends AbstractXmlBasedProvider<String, BindingInfo>
implements BindingInfoProvider,
XmlDocumentProviderFactory<BindingInfoXmlResult> {
    private static final String XML_DIRECTORY = "/ESH-INF/binding/";
    public static final String READY_MARKER = "esh.xmlBindingInfo";
    private BindingI18nUtil bindingI18nUtil;
    private AbstractXmlConfigDescriptionProvider configDescriptionProvider;
    private XmlDocumentBundleTracker<BindingInfoXmlResult> bindingInfoTracker;
    private ReadyService readyService;
    private ScheduledExecutorService scheduler = ThreadPoolManager.getScheduledPool((String)"file-processing");
    private Future<?> trackerJob;

    @Activate
    public void activate(ComponentContext componentContext) {
        BindingInfoReader bindingInfoReader = new BindingInfoReader();
        this.bindingInfoTracker = new XmlDocumentBundleTracker(componentContext.getBundleContext(), XML_DIRECTORY, (XmlDocumentReader)bindingInfoReader, (XmlDocumentProviderFactory)this, READY_MARKER, this.readyService);
        this.trackerJob = this.scheduler.submit(() -> this.bindingInfoTracker.open());
    }

    @Deactivate
    public void deactivate(ComponentContext componentContext) {
        if (this.trackerJob != null && !this.trackerJob.isDone()) {
            this.trackerJob.cancel(true);
            this.trackerJob = null;
        }
        this.bindingInfoTracker.close();
        this.bindingInfoTracker = null;
    }

    public synchronized BindingInfo getBindingInfo(String id, Locale locale) {
        return (BindingInfo)this.get(id, locale);
    }

    public synchronized Set<BindingInfo> getBindingInfos(Locale locale) {
        return new HashSet<BindingInfo>(this.getAll(locale));
    }

    @Reference
    public void setTranslationProvider(TranslationProvider i18nProvider) {
        this.bindingI18nUtil = new BindingI18nUtil(i18nProvider);
    }

    public void unsetTranslationProvider(TranslationProvider i18nProvider) {
        this.bindingI18nUtil = null;
    }

    @Reference(target="(esh.scope=core.xml.binding)")
    public void setConfigDescriptionProvider(ConfigDescriptionProvider configDescriptionProvider) {
        this.configDescriptionProvider = (AbstractXmlConfigDescriptionProvider)configDescriptionProvider;
    }

    public void unsetConfigDescriptionProvider(ConfigDescriptionProvider configDescriptionProvider) {
        this.configDescriptionProvider = null;
    }

    @Reference
    public void setReadyService(ReadyService readyService) {
        this.readyService = readyService;
    }

    public void unsetReadyService(ReadyService readyService) {
        this.readyService = null;
    }

    protected BindingInfo localize(Bundle bundle, BindingInfo bindingInfo, Locale locale) {
        if (this.bindingI18nUtil == null) {
            return null;
        }
        String name = this.bindingI18nUtil.getName(bundle, bindingInfo.getUID(), bindingInfo.getName(), locale);
        String description = this.bindingI18nUtil.getDescription(bundle, bindingInfo.getUID(), bindingInfo.getDescription(), locale);
        return new BindingInfo(bindingInfo.getUID(), name, description, bindingInfo.getAuthor(), bindingInfo.getServiceId(), bindingInfo.getConfigDescriptionURI());
    }

    public XmlDocumentProvider<BindingInfoXmlResult> createDocumentProvider(Bundle bundle) {
        return new BindingInfoXmlProvider(bundle, this, this.configDescriptionProvider);
    }
}

