/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.thing.UID;
import org.eclipse.smarthome.core.thing.i18n.ChannelTypeI18nLocalizationService;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.ChannelTypeBuilder;
import org.eclipse.smarthome.core.thing.type.ChannelTypeProvider;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;
import org.eclipse.smarthome.core.thing.type.StateChannelTypeBuilder;
import org.eclipse.smarthome.core.types.EventDescription;
import org.eclipse.smarthome.core.types.EventOption;
import org.eclipse.smarthome.core.types.StateDescription;
import org.eclipse.smarthome.core.types.StateDescriptionFragmentBuilder;
import org.eclipse.smarthome.core.types.StateOption;
import org.eclipse.smarthome.core.util.BundleResolver;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class DefaultSystemChannelTypeProvider
implements ChannelTypeProvider {
    static final String BINDING_ID = "system";
    public static final ChannelType SYSTEM_CHANNEL_SIGNAL_STRENGTH = ((StateChannelTypeBuilder)ChannelTypeBuilder.state(new ChannelTypeUID("system", "signal-strength"), "Signal Strength", "Number").withCategory("QualityOfService")).withStateDescription(new StateDescription(BigDecimal.ZERO, new BigDecimal(4), BigDecimal.ONE, null, true, Arrays.asList(new StateOption("0", "no signal"), new StateOption("1", "weak"), new StateOption("2", "average"), new StateOption("3", "good"), new StateOption("4", "excellent")))).build();
    public static final ChannelType SYSTEM_CHANNEL_LOW_BATTERY = ((StateChannelTypeBuilder)ChannelTypeBuilder.state(new ChannelTypeUID("system", "low-battery"), "Low Battery", "Switch").withCategory("Battery")).withStateDescription(StateDescriptionFragmentBuilder.create().withReadOnly(Boolean.valueOf(true)).build().toStateDescription()).build();
    public static final ChannelType SYSTEM_CHANNEL_BATTERY_LEVEL = ((StateChannelTypeBuilder)ChannelTypeBuilder.state(new ChannelTypeUID("system", "battery-level"), "Battery Level", "Number").withCategory("Battery")).withStateDescription(new StateDescription(BigDecimal.ZERO, new BigDecimal(100), BigDecimal.ONE, "%.0f %%", true, null)).build();
    public static final ChannelType SYSTEM_TRIGGER = ChannelTypeBuilder.trigger(new ChannelTypeUID("system", "trigger"), "Trigger").build();
    public static final ChannelType SYSTEM_RAWBUTTON = ChannelTypeBuilder.trigger(new ChannelTypeUID("system", "rawbutton"), "Raw button").withEventDescription(new EventDescription(Arrays.asList(new EventOption("PRESSED", null), new EventOption("RELEASED", null)))).build();
    public static final ChannelType SYSTEM_BUTTON = ChannelTypeBuilder.trigger(new ChannelTypeUID("system", "button"), "Button").withEventDescription(new EventDescription(Arrays.asList(new EventOption("SHORT_PRESSED", null), new EventOption("DOUBLE_PRESSED", null), new EventOption("LONG_PRESSED", null)))).build();
    public static final ChannelType SYSTEM_RAWROCKER = ChannelTypeBuilder.trigger(new ChannelTypeUID("system", "rawrocker"), "Raw rocker button").withEventDescription(new EventDescription(Arrays.asList(new EventOption("DIR1_PRESSED", null), new EventOption("DIR1_RELEASED", null), new EventOption("DIR2_PRESSED", null), new EventOption("DIR2_RELEASED", null)))).build();
    public static final ChannelType SYSTEM_POWER = ((StateChannelTypeBuilder)ChannelTypeBuilder.state(new ChannelTypeUID("system", "power"), "Power", "Switch").withDescription("Device is operable when channel has state ON")).build();
    public static final ChannelType SYSTEM_LOCATION = ((StateChannelTypeBuilder)ChannelTypeBuilder.state(new ChannelTypeUID("system", "location"), "Location", "Location").withDescription("Location in lat./lon./height coordinates")).withStateDescription(StateDescriptionFragmentBuilder.create().withReadOnly(Boolean.valueOf(true)).withPattern("%2$s\u00b0N %3$s\u00b0E %1$sm").build().toStateDescription()).build();
    public static final ChannelType SYSTEM_MOTION = ((StateChannelTypeBuilder)((StateChannelTypeBuilder)ChannelTypeBuilder.state(new ChannelTypeUID("system", "motion"), "Motion", "Switch").withDescription("Motion detected by the device")).withCategory("Motion")).withStateDescription(StateDescriptionFragmentBuilder.create().withReadOnly(Boolean.valueOf(true)).build().toStateDescription()).build();
    public static final ChannelType SYSTEM_BRIGHTNESS = ((StateChannelTypeBuilder)((StateChannelTypeBuilder)ChannelTypeBuilder.state(new ChannelTypeUID("system", "brightness"), "Brightness", "Dimmer").withDescription("Controls the brightness and switches the light on and off")).withCategory("DimmableLight")).withStateDescription(new StateDescription(BigDecimal.ZERO, new BigDecimal(100), null, "%d %%", false, null)).build();
    public static final ChannelType SYSTEM_COLOR = ((StateChannelTypeBuilder)((StateChannelTypeBuilder)ChannelTypeBuilder.state(new ChannelTypeUID("system", "color"), "Color", "Color").withDescription("Controls the color of the light")).withCategory("ColorLight")).build();
    public static final ChannelType SYSTEM_COLOR_TEMPERATURE = ((StateChannelTypeBuilder)((StateChannelTypeBuilder)ChannelTypeBuilder.state(new ChannelTypeUID("system", "color-temperature"), "Color Temperature", "Dimmer").withDescription("Controls the color temperature of the light")).withCategory("ColorLight")).withStateDescription(new StateDescription(BigDecimal.ZERO, new BigDecimal(100), null, "%d", false, null)).build();
    public static final ChannelType SYSTEM_VOLUME = ((StateChannelTypeBuilder)((StateChannelTypeBuilder)ChannelTypeBuilder.state(new ChannelTypeUID("system", "volume"), "Volume", "Dimmer").withDescription("Change the sound volume of a device")).withStateDescription(new StateDescription(BigDecimal.ZERO, new BigDecimal(100), null, "%d %%", false, null)).withCategory("SoundVolume")).build();
    public static final ChannelType SYSTEM_MUTE = ((StateChannelTypeBuilder)((StateChannelTypeBuilder)ChannelTypeBuilder.state(new ChannelTypeUID("system", "mute"), "Mute", "Switch").withDescription("Mute audio of the device")).withCategory("SoundVolume")).build();
    public static final ChannelType SYSTEM_MEDIA_CONTROL = ((StateChannelTypeBuilder)ChannelTypeBuilder.state(new ChannelTypeUID("system", "media-control"), "Media Control", "Player").withCategory("MediaControl")).build();
    public static final ChannelType SYSTEM_MEDIA_TITLE = ((StateChannelTypeBuilder)ChannelTypeBuilder.state(new ChannelTypeUID("system", "media-title"), "Media Title", "String").withDescription("Title of a (played) media file")).withStateDescription(StateDescriptionFragmentBuilder.create().withReadOnly(Boolean.valueOf(true)).build().toStateDescription()).build();
    public static final ChannelType SYSTEM_MEDIA_ARTIST = ((StateChannelTypeBuilder)ChannelTypeBuilder.state(new ChannelTypeUID("system", "media-artist"), "Media Artist", "String").withDescription("Artist of a (played) media file")).withStateDescription(StateDescriptionFragmentBuilder.create().withReadOnly(Boolean.valueOf(true)).build().toStateDescription()).build();
    public static final ChannelType SYSTEM_WIND_DIRECTION = ((StateChannelTypeBuilder)((StateChannelTypeBuilder)ChannelTypeBuilder.state(new ChannelTypeUID("system", "wind-direction"), "Wind Direction", "Number:Angle").withDescription("Current wind direction expressed as an angle")).withCategory("Wind")).withStateDescription(new StateDescription(BigDecimal.ZERO, new BigDecimal(360), null, "%.0f %unit%", true, null)).build();
    public static final ChannelType SYSTEM_WIND_SPEED = ((StateChannelTypeBuilder)((StateChannelTypeBuilder)ChannelTypeBuilder.state(new ChannelTypeUID("system", "wind-speed"), "Wind Speed", "Number:Speed").withDescription("Current wind speed")).withCategory("Wind")).withStateDescription(StateDescriptionFragmentBuilder.create().withReadOnly(Boolean.valueOf(true)).withPattern("%.1f %unit%").build().toStateDescription()).build();
    public static final ChannelType SYSTEM_OUTDOOR_TEMPERATURE = ((StateChannelTypeBuilder)((StateChannelTypeBuilder)ChannelTypeBuilder.state(new ChannelTypeUID("system", "outdoor-temperature"), "Outdoor Temperature", "Number:Temperature").withDescription("Current outdoor temperature")).withCategory("Temperature")).withStateDescription(StateDescriptionFragmentBuilder.create().withReadOnly(Boolean.valueOf(true)).withPattern("%.1f %unit%").build().toStateDescription()).build();
    public static final ChannelType SYSTEM_ATMOSPHERIC_HUMIDITY = ((StateChannelTypeBuilder)((StateChannelTypeBuilder)ChannelTypeBuilder.state(new ChannelTypeUID("system", "atmospheric-humidity"), "Atmospheric Humidity", "Number:Dimensionless").withDescription("Current atmospheric relative humidity")).withCategory("Humidity")).withStateDescription(StateDescriptionFragmentBuilder.create().withReadOnly(Boolean.valueOf(true)).withPattern("%.0f %%").build().toStateDescription()).build();
    public static final ChannelType SYSTEM_BAROMETRIC_PRESSURE = ((StateChannelTypeBuilder)((StateChannelTypeBuilder)ChannelTypeBuilder.state(new ChannelTypeUID("system", "barometric-pressure"), "Barometric Pressure", "Number:Pressure").withDescription("Current barometric pressure")).withCategory("Pressure")).withStateDescription(StateDescriptionFragmentBuilder.create().withReadOnly(Boolean.valueOf(true)).withPattern("%.3f %unit%").build().toStateDescription()).build();
    private static final Collection<ChannelType> CHANNEL_TYPES = Collections.unmodifiableList(Stream.of(SYSTEM_CHANNEL_SIGNAL_STRENGTH, SYSTEM_CHANNEL_LOW_BATTERY, SYSTEM_CHANNEL_BATTERY_LEVEL, SYSTEM_TRIGGER, SYSTEM_RAWBUTTON, SYSTEM_BUTTON, SYSTEM_RAWROCKER, SYSTEM_POWER, SYSTEM_LOCATION, SYSTEM_MOTION, SYSTEM_BRIGHTNESS, SYSTEM_COLOR, SYSTEM_COLOR_TEMPERATURE, SYSTEM_VOLUME, SYSTEM_MUTE, SYSTEM_MEDIA_CONTROL, SYSTEM_MEDIA_TITLE, SYSTEM_MEDIA_ARTIST, SYSTEM_WIND_DIRECTION, SYSTEM_WIND_SPEED, SYSTEM_OUTDOOR_TEMPERATURE, SYSTEM_ATMOSPHERIC_HUMIDITY, SYSTEM_BAROMETRIC_PRESSURE).collect(Collectors.toList()));
    private final Map<LocalizedChannelTypeKey, ChannelType> localizedChannelTypeCache = new ConcurrentHashMap<LocalizedChannelTypeKey, ChannelType>();
    private ChannelTypeI18nLocalizationService channelTypeI18nLocalizationService;
    private BundleResolver bundleResolver;

    @Override
    public Collection<ChannelType> getChannelTypes(Locale locale) {
        ArrayList<ChannelType> allChannelTypes = new ArrayList<ChannelType>();
        Bundle bundle = this.bundleResolver.resolveBundle(DefaultSystemChannelTypeProvider.class);
        for (ChannelType channelType : CHANNEL_TYPES) {
            allChannelTypes.add(this.createLocalizedChannelType(bundle, channelType, locale));
        }
        return allChannelTypes;
    }

    @Override
    public ChannelType getChannelType(ChannelTypeUID channelTypeUID, Locale locale) {
        Bundle bundle = this.bundleResolver.resolveBundle(DefaultSystemChannelTypeProvider.class);
        for (ChannelType channelType : CHANNEL_TYPES) {
            if (!channelTypeUID.equals((Object)channelType.getUID())) continue;
            return this.createLocalizedChannelType(bundle, channelType, locale);
        }
        return null;
    }

    @Reference
    public void setChannelTypeI18nLocalizationService(ChannelTypeI18nLocalizationService channelTypeI18nLocalizationService) {
        this.channelTypeI18nLocalizationService = channelTypeI18nLocalizationService;
    }

    public void unsetChannelTypeI18nLocalizationService(ChannelTypeI18nLocalizationService channelTypeI18nLocalizationService) {
        this.channelTypeI18nLocalizationService = null;
    }

    @Reference
    public void setBundleResolver(BundleResolver bundleResolver) {
        this.bundleResolver = bundleResolver;
    }

    public void unsetBundleResolver(BundleResolver bundleResolver) {
        this.bundleResolver = bundleResolver;
    }

    private ChannelType createLocalizedChannelType(Bundle bundle, ChannelType channelType, Locale locale) {
        LocalizedChannelTypeKey localizedChannelTypeKey = this.getLocalizedChannelTypeKey(channelType.getUID(), locale);
        ChannelType cachedEntry = this.localizedChannelTypeCache.get(localizedChannelTypeKey);
        if (cachedEntry != null) {
            return cachedEntry;
        }
        ChannelType localizedChannelType = this.localize(bundle, channelType, locale);
        if (localizedChannelType != null) {
            this.localizedChannelTypeCache.put(localizedChannelTypeKey, localizedChannelType);
            return localizedChannelType;
        }
        return channelType;
    }

    private @Nullable ChannelType localize(Bundle bundle, ChannelType channelType, Locale locale) {
        if (this.channelTypeI18nLocalizationService == null) {
            return null;
        }
        return this.channelTypeI18nLocalizationService.createLocalizedChannelType(bundle, channelType, locale);
    }

    private LocalizedChannelTypeKey getLocalizedChannelTypeKey(UID uid, Locale locale) {
        return new LocalizedChannelTypeKey(uid, locale != null ? locale.toLanguageTag() : null);
    }

    private static class LocalizedChannelTypeKey {
        public final String locale;
        public final UID uid;

        public LocalizedChannelTypeKey(UID uid, String locale) {
            this.uid = uid;
            this.locale = locale;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LocalizedChannelTypeKey other = (LocalizedChannelTypeKey)obj;
            if (this.locale == null ? other.locale != null : !this.locale.equals(other.locale)) {
                return false;
            }
            return !(this.uid == null ? other.uid != null : !this.uid.equals((Object)other.uid));
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
            result = 31 * result + (this.uid == null ? 0 : this.uid.hashCode());
            return result;
        }
    }
}

