/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing;

public enum ThingStatusDetail {
    NONE,
    HANDLER_MISSING_ERROR,
    HANDLER_REGISTERING_ERROR,
    HANDLER_INITIALIZING_ERROR,
    HANDLER_CONFIGURATION_PENDING,
    CONFIGURATION_PENDING,
    COMMUNICATION_ERROR,
    CONFIGURATION_ERROR,
    BRIDGE_OFFLINE,
    FIRMWARE_UPDATING,
    DUTY_CYCLE,
    BRIDGE_UNINITIALIZED,
    GONE,
    DISABLED;

    public static final UninitializedStatus UNINITIALIZED;
    public static final NoneOnlyStatus INITIALIZING;
    public static final NoneOnlyStatus UNKNOWN;
    public static final OnlineStatus ONLINE;
    public static final OfflineStatus OFFLINE;
    public static final NoneOnlyStatus REMOVING;
    public static final NoneOnlyStatus REMOVED;

    static {
        UNINITIALIZED = new UninitializedStatus();
        INITIALIZING = new NoneOnlyStatus();
        UNKNOWN = new NoneOnlyStatus();
        ONLINE = new OnlineStatus();
        OFFLINE = new OfflineStatus();
        REMOVING = new NoneOnlyStatus();
        REMOVED = new NoneOnlyStatus();
    }

    public static final class NoneOnlyStatus {
        public ThingStatusDetail NONE = NONE;

        private NoneOnlyStatus() {
        }
    }

    public static final class OfflineStatus {
        public ThingStatusDetail NONE = NONE;
        public ThingStatusDetail COMMUNICATION_ERROR = COMMUNICATION_ERROR;
        public ThingStatusDetail CONFIGURATION_ERROR = CONFIGURATION_ERROR;
        public ThingStatusDetail BRIDGE_OFFLINE = BRIDGE_OFFLINE;
        public ThingStatusDetail FIRMWARE_UPDATING = FIRMWARE_UPDATING;
        public ThingStatusDetail DUTY_CYCLE = DUTY_CYCLE;
        public ThingStatusDetail GONE = GONE;

        private OfflineStatus() {
        }
    }

    public static final class OnlineStatus {
        public ThingStatusDetail NONE = NONE;
        public ThingStatusDetail CONFIGURATION_PENDING = CONFIGURATION_PENDING;

        private OnlineStatus() {
        }
    }

    public static final class UninitializedStatus {
        public ThingStatusDetail NONE = NONE;
        public ThingStatusDetail HANDLER_MISSING_ERROR = HANDLER_MISSING_ERROR;
        public ThingStatusDetail HANDLER_REGISTERING_ERROR = HANDLER_REGISTERING_ERROR;
        public ThingStatusDetail HANDLER_CONFIGURATION_PENDING = HANDLER_CONFIGURATION_PENDING;
        public ThingStatusDetail HANDLER_INITIALIZING_ERROR = HANDLER_INITIALIZING_ERROR;
        public ThingStatusDetail BRIDGE_UNINITIALIZED = BRIDGE_UNINITIALIZED;

        private UninitializedStatus() {
        }
    }
}

