/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.binding;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.common.ThreadPoolManager;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.ThingStatusInfo;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerCallback;
import org.eclipse.smarthome.core.thing.binding.builder.ThingBuilder;
import org.eclipse.smarthome.core.thing.binding.builder.ThingStatusInfoBuilder;
import org.eclipse.smarthome.core.thing.util.ThingHandlerHelper;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract class BaseThingHandler
implements ThingHandler {
    private static final String THING_HANDLER_THREADPOOL_NAME = "thingHandler";
    private final Logger logger = LoggerFactory.getLogger(BaseThingHandler.class);
    protected final ScheduledExecutorService scheduler = ThreadPoolManager.getScheduledPool((String)"thingHandler");
    @Deprecated
    @NonNullByDefault(value={})
    protected ThingRegistry thingRegistry;
    @Deprecated
    @NonNullByDefault(value={})
    protected BundleContext bundleContext;
    protected Thing thing;
    @NonNullByDefault(value={})
    private ServiceTracker thingRegistryServiceTracker;
    private @Nullable ThingHandlerCallback callback;

    public BaseThingHandler(Thing thing) {
        this.thing = thing;
    }

    public void setBundleContext(final BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.thingRegistryServiceTracker = new ServiceTracker(this.bundleContext, ThingRegistry.class.getName(), null){

            public Object addingService(@Nullable ServiceReference reference) {
                BaseThingHandler.this.thingRegistry = (ThingRegistry)bundleContext.getService(reference);
                return BaseThingHandler.this.thingRegistry;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removedService(@Nullable ServiceReference reference, @Nullable Object service) {
                BaseThingHandler baseThingHandler = BaseThingHandler.this;
                synchronized (baseThingHandler) {
                    BaseThingHandler.this.thingRegistry = null;
                }
            }
        };
        this.thingRegistryServiceTracker.open();
    }

    public void unsetBundleContext(BundleContext bundleContext) {
        this.thingRegistryServiceTracker.close();
        this.bundleContext = null;
    }

    @Override
    public void handleRemoval() {
        this.updateStatus(ThingStatus.REMOVED);
    }

    @Override
    public void handleConfigurationUpdate(Map<String, Object> configurationParameters) {
        if (!this.isModifyingCurrentConfig(configurationParameters)) {
            return;
        }
        this.validateConfigurationParameters(configurationParameters);
        Configuration configuration = this.editConfiguration();
        for (Map.Entry<String, Object> configurationParameter : configurationParameters.entrySet()) {
            configuration.put(configurationParameter.getKey(), configurationParameter.getValue());
        }
        if (this.isInitialized()) {
            this.dispose();
            this.updateConfiguration(configuration);
            this.initialize();
        } else {
            this.updateConfiguration(configuration);
            if (this.callback != null) {
                this.callback.configurationUpdated(this.getThing());
            } else {
                this.logger.warn("Handler {} tried updating its configuration although the handler was already disposed.", (Object)this.getClass().getSimpleName());
            }
        }
    }

    protected boolean isModifyingCurrentConfig(Map<String, Object> configurationParameters) {
        Configuration currentConfig = this.getConfig();
        for (Map.Entry<String, Object> entry : configurationParameters.entrySet()) {
            if (Objects.equals(currentConfig.get(entry.getKey()), entry.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void dispose() {
    }

    @Override
    public Thing getThing() {
        return this.thing;
    }

    @Override
    @Deprecated
    public void handleUpdate(ChannelUID channelUID, State newState) {
    }

    @Override
    @Deprecated
    public void initialize() {
        this.updateStatus(ThingStatus.ONLINE);
        this.logger.warn("BaseThingHandler.initialize() will be removed soon, ThingStatus can be set manually via updateStatus(ThingStatus.ONLINE)");
    }

    @Override
    public void thingUpdated(Thing thing) {
        this.dispose();
        this.thing = thing;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCallback(@Nullable ThingHandlerCallback thingHandlerCallback) {
        BaseThingHandler baseThingHandler = this;
        synchronized (baseThingHandler) {
            this.callback = thingHandlerCallback;
        }
    }

    protected @Nullable ThingHandlerCallback getCallback() {
        return this.callback;
    }

    @Override
    public void channelLinked(ChannelUID channelUID) {
        this.handleCommand(channelUID, (Command)RefreshType.REFRESH);
    }

    @Override
    public void channelUnlinked(ChannelUID channelUID) {
    }

    protected void validateConfigurationParameters(Map<String, Object> configurationParameters) {
        if (this.callback != null) {
            this.callback.validateConfigurationParameters(this.getThing(), configurationParameters);
        } else {
            this.logger.warn("Handler {} tried validating its configuration although the handler was already disposed.", (Object)this.getClass().getSimpleName());
        }
    }

    protected Configuration getConfig() {
        return this.getThing().getConfiguration();
    }

    protected <T> T getConfigAs(Class<T> configurationClass) {
        return (T)this.getConfig().as(configurationClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateState(ChannelUID channelUID, State state) {
        BaseThingHandler baseThingHandler = this;
        synchronized (baseThingHandler) {
            if (this.callback != null) {
                this.callback.stateUpdated(channelUID, state);
            } else {
                this.logger.warn("Handler {} of thing {} tried updating channel {} although the handler was already disposed.", new Object[]{this.getClass().getSimpleName(), channelUID.getThingUID(), channelUID.getId()});
            }
        }
    }

    protected void updateState(String channelID, State state) {
        ChannelUID channelUID = new ChannelUID(this.getThing().getUID(), channelID);
        this.updateState(channelUID, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerChannel(ChannelUID channelUID, String event) {
        BaseThingHandler baseThingHandler = this;
        synchronized (baseThingHandler) {
            if (this.callback != null) {
                this.callback.channelTriggered(this.getThing(), channelUID, event);
            } else {
                this.logger.warn("Handler {} of thing {} tried triggering channel {} although the handler was already disposed.", new Object[]{this.getClass().getSimpleName(), channelUID.getThingUID(), channelUID.getId()});
            }
        }
    }

    protected void triggerChannel(String channelID, String event) {
        this.triggerChannel(new ChannelUID(this.getThing().getUID(), channelID), event);
    }

    protected void triggerChannel(String channelUID) {
        this.triggerChannel(new ChannelUID(this.getThing().getUID(), channelUID), "");
    }

    protected void triggerChannel(ChannelUID channelUID) {
        this.triggerChannel(channelUID, "");
    }

    protected void postCommand(String channelID, Command command) {
        ChannelUID channelUID = new ChannelUID(this.getThing().getUID(), channelID);
        this.postCommand(channelUID, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postCommand(ChannelUID channelUID, Command command) {
        BaseThingHandler baseThingHandler = this;
        synchronized (baseThingHandler) {
            if (this.callback != null) {
                this.callback.postCommand(channelUID, command);
            } else {
                this.logger.warn("Handler {} of thing {} tried posting a command to channel {} although the handler was already disposed.", new Object[]{this.getClass().getSimpleName(), channelUID.getThingUID(), channelUID.getId()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateStatus(ThingStatus status, ThingStatusDetail statusDetail, @Nullable String description) {
        BaseThingHandler baseThingHandler = this;
        synchronized (baseThingHandler) {
            if (this.callback != null) {
                ThingStatusInfoBuilder statusBuilder = ThingStatusInfoBuilder.create(status, statusDetail);
                ThingStatusInfo statusInfo = statusBuilder.withDescription(description).build();
                this.callback.statusUpdated(this.thing, statusInfo);
            } else {
                this.logger.warn("Handler {} tried updating the thing status although the handler was already disposed.", (Object)this.getClass().getSimpleName());
            }
        }
    }

    protected void updateStatus(ThingStatus status, ThingStatusDetail statusDetail) {
        this.updateStatus(status, statusDetail, null);
    }

    protected void updateStatus(ThingStatus status) {
        this.updateStatus(status, ThingStatusDetail.NONE, null);
    }

    protected ThingBuilder editThing() {
        return ThingBuilder.create(this.thing.getThingTypeUID(), this.thing.getUID()).withBridge(this.thing.getBridgeUID()).withChannels(this.thing.getChannels()).withConfiguration(this.thing.getConfiguration()).withLabel(this.thing.getLabel()).withLocation(this.thing.getLocation()).withProperties(this.thing.getProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateThing(Thing thing) {
        if (thing == this.thing) {
            throw new IllegalArgumentException("Changes must not be done on the current thing - create a copy, e.g. via editThing()");
        }
        BaseThingHandler baseThingHandler = this;
        synchronized (baseThingHandler) {
            if (this.callback != null) {
                this.thing = thing;
                this.callback.thingUpdated(thing);
            } else {
                this.logger.warn("Handler {} tried updating thing {} although the handler was already disposed.", (Object)this.getClass().getSimpleName(), (Object)thing.getUID());
            }
        }
    }

    protected Configuration editConfiguration() {
        Map properties = this.thing.getConfiguration().getProperties();
        return new Configuration(new HashMap(properties));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateConfiguration(Configuration configuration) {
        Map old = this.thing.getConfiguration().getProperties();
        try {
            this.thing.getConfiguration().setProperties(configuration.getProperties());
            BaseThingHandler baseThingHandler = this;
            synchronized (baseThingHandler) {
                if (this.callback != null) {
                    this.callback.thingUpdated(this.thing);
                } else {
                    this.logger.warn("Handler {} tried updating its configuration although the handler was already disposed.", (Object)this.getClass().getSimpleName());
                }
            }
        }
        catch (RuntimeException e) {
            this.logger.warn("Error while applying configuration changes: '{}: {}' - reverting configuration changes on thing '{}'.", new Object[]{e.getClass().getSimpleName(), e.getMessage(), this.thing.getUID().getAsString()});
            this.thing.getConfiguration().setProperties(old);
            throw e;
        }
    }

    protected Map<String, String> editProperties() {
        Map<String, String> properties = this.thing.getProperties();
        return new HashMap<String, String>(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateProperties(Map<String, String> properties) {
        boolean propertiesUpdated = false;
        for (Map.Entry<String, String> property : properties.entrySet()) {
            String propertyName = property.getKey();
            String propertyValue = property.getValue();
            String existingPropertyValue = this.thing.getProperties().get(propertyName);
            if (existingPropertyValue != null && existingPropertyValue.equals(propertyValue)) continue;
            this.thing.setProperty(propertyName, propertyValue);
            propertiesUpdated = true;
        }
        if (propertiesUpdated) {
            BaseThingHandler baseThingHandler = this;
            synchronized (baseThingHandler) {
                if (this.callback != null) {
                    this.callback.thingUpdated(this.thing);
                } else {
                    this.logger.warn("Handler {} tried updating its thing's properties although the handler was already disposed.", (Object)this.getClass().getSimpleName());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateProperty(String name, String value) {
        String existingPropertyValue = this.thing.getProperties().get(name);
        if (existingPropertyValue == null || !existingPropertyValue.equals(value)) {
            this.thing.setProperty(name, value);
            BaseThingHandler baseThingHandler = this;
            synchronized (baseThingHandler) {
                if (this.callback != null) {
                    this.callback.thingUpdated(this.thing);
                } else {
                    this.logger.warn("Handler {} tried updating its thing's properties although the handler was already disposed.", (Object)this.getClass().getSimpleName());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected @Nullable Bridge getBridge() {
        ThingUID bridgeUID = this.thing.getBridgeUID();
        BaseThingHandler baseThingHandler = this;
        synchronized (baseThingHandler) {
            if (bridgeUID != null && this.thingRegistry != null) {
                return (Bridge)this.thingRegistry.get(bridgeUID);
            }
            return null;
        }
    }

    protected boolean isLinked(String channelId) {
        ChannelUID channelUID = new ChannelUID(this.getThing().getUID(), channelId);
        return this.isLinked(channelUID);
    }

    protected boolean isLinked(ChannelUID channelUID) {
        if (this.callback != null) {
            return this.callback.isChannelLinked(channelUID);
        }
        this.logger.warn("Handler {} of thing {} tried checking if channel {} is linked although the handler was already disposed.", new Object[]{this.getClass().getSimpleName(), channelUID.getThingUID(), channelUID.getId()});
        return false;
    }

    protected boolean isInitialized() {
        return ThingHandlerHelper.isHandlerInitialized(this);
    }

    @Override
    public void bridgeStatusChanged(ThingStatusInfo bridgeStatusInfo) {
        if (bridgeStatusInfo.getStatus() == ThingStatus.ONLINE && this.getThing().getStatusInfo().getStatusDetail() == ThingStatusDetail.BRIDGE_OFFLINE) {
            this.updateStatus(ThingStatus.ONLINE, ThingStatusDetail.NONE);
        } else if (bridgeStatusInfo.getStatus() == ThingStatus.OFFLINE) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.BRIDGE_OFFLINE);
        }
    }

    protected void changeThingType(ThingTypeUID thingTypeUID, Configuration configuration) {
        if (this.callback != null) {
            this.callback.migrateThingType(this.getThing(), thingTypeUID, configuration);
        } else {
            this.logger.warn("Handler {} tried migrating the thing type although the handler was already disposed.", (Object)this.getClass().getSimpleName());
        }
    }
}

