/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.firmware;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.smarthome.core.events.AbstractEventFactory;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventFactory;
import org.eclipse.smarthome.core.thing.firmware.FirmwareStatusInfo;
import org.eclipse.smarthome.core.thing.firmware.FirmwareStatusInfoEvent;
import org.eclipse.smarthome.core.thing.firmware.FirmwareUpdateProgressInfo;
import org.eclipse.smarthome.core.thing.firmware.FirmwareUpdateProgressInfoEvent;
import org.eclipse.smarthome.core.thing.firmware.FirmwareUpdateResultInfo;
import org.eclipse.smarthome.core.thing.firmware.FirmwareUpdateResultInfoEvent;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={EventFactory.class})
public final class FirmwareEventFactory
extends AbstractEventFactory {
    static final String THING_UID_TOPIC_KEY = "{thingUID}";
    static final String FIRMWARE_STATUS_TOPIC = "smarthome/things/{thingUID}/firmware/status";
    static final String FIRMWARE_UPDATE_PROGRESS_TOPIC = "smarthome/things/{thingUID}/firmware/update/progress";
    static final String FIRMWARE_UPDATE_RESULT_TOPIC = "smarthome/things/{thingUID}/firmware/update/result";

    public FirmwareEventFactory() {
        super(Stream.of(FirmwareStatusInfoEvent.TYPE, FirmwareUpdateProgressInfoEvent.TYPE, FirmwareUpdateResultInfoEvent.TYPE).collect(Collectors.toSet()));
    }

    protected Event createEventByType(String eventType, String topic, String payload, String source) throws Exception {
        if (FirmwareStatusInfoEvent.TYPE.equals(eventType)) {
            return FirmwareEventFactory.createFirmwareStatusInfoEvent(topic, payload);
        }
        if (FirmwareUpdateProgressInfoEvent.TYPE.equals(eventType)) {
            return FirmwareEventFactory.createFirmwareUpdateProgressInfoEvent(topic, payload);
        }
        if (FirmwareUpdateResultInfoEvent.TYPE.equals(eventType)) {
            return FirmwareEventFactory.createFirmwareUpdateResultInfoEvent(topic, payload);
        }
        return null;
    }

    public static FirmwareStatusInfoEvent createFirmwareStatusInfoEvent(FirmwareStatusInfo firmwareStatusInfo) {
        FirmwareEventFactory.checkNotNull((Object)firmwareStatusInfo, (String)"firmwareStatusInfo");
        String topic = FIRMWARE_STATUS_TOPIC.replace(THING_UID_TOPIC_KEY, firmwareStatusInfo.getThingUID().getAsString());
        String payload = FirmwareEventFactory.serializePayload((Object)firmwareStatusInfo);
        return new FirmwareStatusInfoEvent(topic, payload, firmwareStatusInfo);
    }

    public static FirmwareUpdateProgressInfoEvent createFirmwareUpdateProgressInfoEvent(FirmwareUpdateProgressInfo progressInfo) {
        FirmwareEventFactory.checkNotNull((Object)progressInfo, (String)"progressInfo");
        String topic = FIRMWARE_UPDATE_PROGRESS_TOPIC.replace(THING_UID_TOPIC_KEY, progressInfo.getThingUID().getAsString());
        String payload = FirmwareEventFactory.serializePayload((Object)progressInfo);
        return new FirmwareUpdateProgressInfoEvent(topic, payload, progressInfo);
    }

    public static FirmwareUpdateResultInfoEvent createFirmwareUpdateResultInfoEvent(FirmwareUpdateResultInfo firmwareUpdateResultInfo) {
        FirmwareEventFactory.checkNotNull((Object)firmwareUpdateResultInfo, (String)"firmwareUpdateResultInfo");
        String topic = FIRMWARE_UPDATE_RESULT_TOPIC.replace(THING_UID_TOPIC_KEY, firmwareUpdateResultInfo.getThingUID().getAsString());
        String payload = FirmwareEventFactory.serializePayload((Object)firmwareUpdateResultInfo);
        return new FirmwareUpdateResultInfoEvent(topic, payload, firmwareUpdateResultInfo);
    }

    private static FirmwareStatusInfoEvent createFirmwareStatusInfoEvent(String topic, String payload) {
        FirmwareStatusInfo firmwareStatusInfo = (FirmwareStatusInfo)FirmwareEventFactory.deserializePayload((String)payload, FirmwareStatusInfo.class);
        return new FirmwareStatusInfoEvent(topic, payload, firmwareStatusInfo);
    }

    private static FirmwareUpdateProgressInfoEvent createFirmwareUpdateProgressInfoEvent(String topic, String payload) {
        FirmwareUpdateProgressInfo firmwareUpdateProgressInfo = (FirmwareUpdateProgressInfo)FirmwareEventFactory.deserializePayload((String)payload, FirmwareUpdateProgressInfo.class);
        return new FirmwareUpdateProgressInfoEvent(topic, payload, firmwareUpdateProgressInfo);
    }

    private static FirmwareUpdateResultInfoEvent createFirmwareUpdateResultInfoEvent(String topic, String payload) {
        FirmwareUpdateResultInfo firmwareUpdateResultInfo = (FirmwareUpdateResultInfo)FirmwareEventFactory.deserializePayload((String)payload, FirmwareUpdateResultInfo.class);
        return new FirmwareUpdateResultInfoEvent(topic, payload, firmwareUpdateResultInfo);
    }
}

