/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.internal.console;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.ManagedThingProvider;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingManager;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.ThingStatusInfo;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.events.ThingEventFactory;
import org.eclipse.smarthome.core.thing.i18n.ThingStatusInfoI18nLocalizationService;
import org.eclipse.smarthome.io.console.Console;
import org.eclipse.smarthome.io.console.extensions.AbstractConsoleCommandExtension;
import org.eclipse.smarthome.io.console.extensions.ConsoleCommandExtension;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ConsoleCommandExtension.class})
public class ThingConsoleCommandExtension
extends AbstractConsoleCommandExtension {
    private static final String CMD_THINGS = "things";
    private static final String SUBCMD_LIST = "list";
    private static final String SUBCMD_SHOW = "show";
    private static final String SUBCMD_CLEAR = "clear";
    private static final String SUBCMD_REMOVE = "remove";
    private static final String SUBCMD_TRIGGER = "trigger";
    private static final String SUBCMD_DISABLE = "disable";
    private static final String SUBCMD_ENABLE = "enable";
    private ManagedThingProvider managedThingProvider;
    private ThingRegistry thingRegistry;
    private ThingStatusInfoI18nLocalizationService thingStatusInfoI18nLocalizationService;
    private EventPublisher eventPublisher;
    private ThingManager thingManager;

    public ThingConsoleCommandExtension() {
        super(CMD_THINGS, "Access your thing registry.");
    }

    public void execute(String[] args, Console console) {
        block32: {
            block30: {
                String subCommand;
                Collection things = this.thingRegistry.getAll();
                if (args.length <= 0) break block30;
                switch (subCommand = args[0]) {
                    case "list": {
                        this.printThings(console, things);
                        return;
                    }
                    case "show": {
                        this.printThingsDetails(console, Arrays.asList(args).subList(1, args.length));
                        return;
                    }
                    case "clear": {
                        this.removeAllThings(console, things);
                        return;
                    }
                    case "remove": {
                        if (args.length > 1) {
                            ThingUID thingUID = new ThingUID(args[1]);
                            this.removeThing(console, thingUID);
                        } else {
                            console.println("Specify thing id to remove: things remove <thingUID> (e.g. \"hue:light:1\")");
                        }
                        return;
                    }
                    case "trigger": {
                        if (args.length == 3) {
                            this.triggerChannel(console, args[1], args[2]);
                            break;
                        }
                        if (args.length == 2) {
                            this.triggerChannel(console, args[1], null);
                            break;
                        }
                        console.println("Command '" + subCommand + "' needs arguments <channelUID> [<event>]");
                        break;
                    }
                    case "enable": 
                    case "disable": {
                        if (args.length > 1) {
                            ThingUID thingUID = new ThingUID(args[1]);
                            this.enableThing(console, thingUID, subCommand.equals(SUBCMD_ENABLE));
                        } else {
                            console.println("Command '" + subCommand + "' needs argument <thingUID> (e.g. \"hue:light:1\")");
                        }
                        return;
                    }
                }
                break block32;
            }
            this.printUsage(console);
        }
    }

    private void triggerChannel(Console console, String channelUid, String event) {
        this.eventPublisher.post((Event)ThingEventFactory.createTriggerEvent(event, new ChannelUID(channelUid)));
    }

    private void removeThing(Console console, ThingUID thingUID) {
        Thing removedThing = (Thing)this.managedThingProvider.remove((Object)thingUID);
        if (removedThing != null) {
            console.println("Thing '" + (Object)((Object)thingUID) + "' successfully removed.");
        } else {
            console.println("Could not delete thing " + (Object)((Object)thingUID) + ".");
        }
    }

    private void removeAllThings(Console console, Collection<Thing> things) {
        int numberOfThings = things.size();
        for (Thing thing : things) {
            this.managedThingProvider.remove((Object)thing.getUID());
        }
        console.println(String.valueOf(numberOfThings) + " things successfully removed.");
    }

    private void enableThing(Console console, ThingUID thingUID, boolean isEnabled) {
        if (this.thingRegistry.get(thingUID) == null) {
            console.println("unknown thing for thingUID '" + thingUID.getAsString() + "'.");
            return;
        }
        this.thingManager.setEnabled(thingUID, isEnabled);
        String command = isEnabled ? "enabled" : "disabled";
        console.println(String.valueOf(thingUID.getAsString()) + " successfully " + command + ".");
    }

    public List<String> getUsages() {
        return Arrays.asList(this.buildCommandUsage(SUBCMD_LIST, "lists all things"), this.buildCommandUsage("show <thingUID>*", "show details about one or more things; show details for all things if no thingUID provided"), this.buildCommandUsage(SUBCMD_CLEAR, "removes all managed things"), this.buildCommandUsage("remove <thingUID>", "removes a thing"), this.buildCommandUsage("trigger <channelUID> [<event>]", "triggers the <channelUID> with <event> (if given)"), this.buildCommandUsage("disable <thingUID>", "disables a thing"), this.buildCommandUsage("enable <thingUID>", "enables a thing"));
    }

    private void printThings(Console console, Collection<Thing> things) {
        if (things.isEmpty()) {
            console.println("No things found.");
        }
        for (Thing thing : things) {
            String id = thing.getUID().toString();
            String thingType = thing instanceof Bridge ? "Bridge" : "Thing";
            ThingStatusInfo status = this.thingStatusInfoI18nLocalizationService.getLocalizedThingStatusInfo(thing, null);
            ThingUID bridgeUID = thing.getBridgeUID();
            String label = thing.getLabel();
            console.println(String.format("%s (Type=%s, Status=%s, Label=%s, Bridge=%s)", new Object[]{id, thingType, status, label, bridgeUID}));
        }
    }

    private void printThingsDetails(Console console, List<String> thingUIDStrings) {
        ArrayList<Thing> things;
        if (thingUIDStrings.isEmpty()) {
            things = this.thingRegistry.getAll();
        } else {
            things = new ArrayList<Thing>();
            for (String thingUIDString : thingUIDStrings) {
                ThingUID thingUID;
                try {
                    thingUID = new ThingUID(thingUIDString);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    console.println("This is not a valid thing UID: " + thingUIDString);
                    return;
                }
                Thing thing = this.thingRegistry.get(thingUID);
                if (thing == null) {
                    console.println("Could not find thing with UID " + (Object)((Object)thingUID));
                    return;
                }
                things.add(thing);
            }
        }
        this.printThingsDetails(console, (Collection<Thing>)things);
    }

    private void printThingsDetails(Console console, Collection<Thing> things) {
        Iterator<Thing> iter = things.iterator();
        while (iter.hasNext()) {
            this.printThingDetails(console, iter.next());
            if (!iter.hasNext()) continue;
            console.println("");
            console.println("--- --- --- --- ---");
            console.println("");
        }
    }

    private void printThingDetails(Console console, Thing thing) {
        console.println("UID: " + (Object)((Object)thing.getUID()));
        console.println("Type: " + (Object)((Object)thing.getThingTypeUID()));
        console.println("Label: " + thing.getLabel());
        console.println("Status: " + this.thingStatusInfoI18nLocalizationService.getLocalizedThingStatusInfo(thing, null));
        if (thing.getBridgeUID() != null) {
            console.println("Bridge: " + (Object)((Object)thing.getBridgeUID()));
        }
        console.println("");
        if (thing.getProperties().isEmpty()) {
            console.println("No properties");
        } else {
            console.println("Properties:");
            for (Map.Entry<String, String> entry : thing.getProperties().entrySet()) {
                console.println("\t" + entry.getKey() + " : " + entry.getValue());
            }
        }
        console.println("");
        if (thing.getConfiguration().getProperties().isEmpty()) {
            console.println("No configuration parameters");
        } else {
            console.println("Configuration parameters:");
            for (Map.Entry<String, String> entry : thing.getConfiguration().getProperties().entrySet()) {
                console.println("\t" + entry.getKey() + " : " + entry.getValue());
            }
        }
        console.println("");
        if (thing.getChannels().isEmpty()) {
            console.println("No channels");
        } else {
            console.println("Channels:");
            Iterator<Channel> iterator = thing.getChannels().iterator();
            while (iterator.hasNext()) {
                Channel channel = iterator.next();
                console.println("\tID: " + channel.getUID().getId());
                console.println("\tLabel: " + channel.getLabel());
                console.println("\tType: " + (Object)((Object)channel.getChannelTypeUID()));
                if (channel.getDescription() != null) {
                    console.println("\tDescription: " + channel.getDescription());
                }
                if (!iterator.hasNext()) continue;
                console.println("");
            }
        }
    }

    @Reference
    protected void setManagedThingProvider(ManagedThingProvider managedThingProvider) {
        this.managedThingProvider = managedThingProvider;
    }

    @Reference
    protected void setThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = thingRegistry;
    }

    protected void unsetManagedThingProvider(ManagedThingProvider managedThingProvider) {
        this.managedThingProvider = null;
    }

    protected void unsetThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = null;
    }

    @Reference
    protected void setThingStatusInfoI18nLocalizationService(ThingStatusInfoI18nLocalizationService thingStatusInfoI18nLocalizationService) {
        this.thingStatusInfoI18nLocalizationService = thingStatusInfoI18nLocalizationService;
    }

    protected void unsetThingStatusInfoI18nLocalizationService(ThingStatusInfoI18nLocalizationService thingStatusInfoI18nLocalizationService) {
        this.thingStatusInfoI18nLocalizationService = null;
    }

    @Reference
    protected void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }

    @Reference
    protected void setThingManager(ThingManager thingManager) {
        this.thingManager = thingManager;
    }

    protected void unsetThingManager(ThingManager thingManager) {
        this.thingManager = null;
    }
}

