/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.internal.firmware;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.firmware.Firmware;
import org.eclipse.smarthome.core.thing.binding.firmware.FirmwareRestriction;
import org.eclipse.smarthome.core.thing.internal.firmware.ParameterChecks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public final class FirmwareImpl
implements Firmware {
    public static final String PROPERTY_REQUIRES_FACTORY_RESET = "requiresFactoryReset";
    private final Logger logger = LoggerFactory.getLogger(FirmwareImpl.class);
    private final ThingTypeUID thingTypeUID;
    private final @Nullable String vendor;
    private final @Nullable String model;
    private final boolean modelRestricted;
    private final @Nullable String description;
    private final Version version;
    private final @Nullable Version prerequisiteVersion;
    private final FirmwareRestriction firmwareRestriction;
    private final @Nullable String changelog;
    private final @Nullable URL onlineChangelog;
    private final transient @Nullable InputStream inputStream;
    private final @Nullable String md5Hash;
    private final Map<String, String> properties;
    private transient byte @Nullable [] bytes;

    public FirmwareImpl(ThingTypeUID thingTypeUID, @Nullable String vendor, @Nullable String model, boolean modelRestricted, @Nullable String description, String version, @Nullable String prerequisiteVersion, @Nullable FirmwareRestriction firmwareRestriction, @Nullable String changelog, @Nullable URL onlineChangelog, @Nullable InputStream inputStream, @Nullable String md5Hash, @Nullable Map<String, String> properties) {
        ParameterChecks.checkNotNull((Object)thingTypeUID, "ThingTypeUID");
        this.thingTypeUID = thingTypeUID;
        ParameterChecks.checkNotNullOrEmpty(version, "Firmware version");
        this.version = new Version(version);
        this.vendor = vendor;
        this.model = model;
        this.modelRestricted = modelRestricted;
        this.description = description;
        this.prerequisiteVersion = prerequisiteVersion != null ? new Version(prerequisiteVersion) : null;
        this.firmwareRestriction = firmwareRestriction != null ? firmwareRestriction : t -> true;
        this.changelog = changelog;
        this.onlineChangelog = onlineChangelog;
        this.inputStream = inputStream;
        this.md5Hash = md5Hash;
        this.properties = Collections.unmodifiableMap(properties != null ? properties : Collections.emptyMap());
    }

    @Override
    public ThingTypeUID getThingTypeUID() {
        return this.thingTypeUID;
    }

    @Override
    public @Nullable String getVendor() {
        return this.vendor;
    }

    @Override
    public @Nullable String getModel() {
        return this.model;
    }

    @Override
    public boolean isModelRestricted() {
        return this.modelRestricted;
    }

    @Override
    public @Nullable String getDescription() {
        return this.description;
    }

    @Override
    public String getVersion() {
        return this.version.toString();
    }

    @Override
    public @Nullable String getPrerequisiteVersion() {
        return this.prerequisiteVersion != null ? this.prerequisiteVersion.toString() : null;
    }

    @Override
    public FirmwareRestriction getFirmwareRestriction() {
        return this.firmwareRestriction;
    }

    @Override
    public @Nullable String getChangelog() {
        return this.changelog;
    }

    @Override
    public @Nullable URL getOnlineChangelog() {
        return this.onlineChangelog;
    }

    @Override
    public @Nullable InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public @Nullable String getMd5Hash() {
        return this.md5Hash;
    }

    @Override
    public synchronized byte @Nullable [] getBytes() {
        if (this.inputStream == null) {
            return null;
        }
        if (this.bytes == null) {
            MessageDigest md = MessageDigest.getInstance("MD5");
            try {
                Throwable throwable = null;
                Object var3_6 = null;
                try (DigestInputStream dis = new DigestInputStream(this.inputStream, md);){
                    this.bytes = IOUtils.toByteArray((InputStream)dis);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ioEx) {
                this.logger.error("Cannot read firmware {}.", (Object)this, (Object)ioEx);
                return null;
            }
            try {
                byte[] digest = md.digest();
                if (this.md5Hash != null && digest != null) {
                    StringBuilder digestString = new StringBuilder();
                    byte[] byArray = digest;
                    int n = digest.length;
                    int n2 = 0;
                    while (n2 < n) {
                        byte b = byArray[n2];
                        digestString.append(String.format("%02x", b));
                        ++n2;
                    }
                    if (!this.md5Hash.equals(digestString.toString())) {
                        this.bytes = null;
                        throw new IllegalStateException(String.format("Invalid MD5 checksum. Expected %s, but was %s.", this.md5Hash, digestString));
                    }
                }
            }
            catch (NoSuchAlgorithmException e) {
                this.logger.error("Cannot calculate MD5 checksum.", (Throwable)e);
                this.bytes = null;
                return null;
            }
        }
        return this.bytes;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public boolean isSuccessorVersion(@Nullable String firmwareVersion) {
        if (firmwareVersion == null) {
            return false;
        }
        return this.version.compare(new Version(firmwareVersion)) > 0;
    }

    @Override
    public boolean isSuitableFor(Thing thing) {
        return this.hasSameThingType(thing) && this.hasRequiredModel(thing) && this.firmwareOnThingIsHighEnough(thing) && (Boolean)this.firmwareRestriction.apply(thing) != false;
    }

    @Override
    public int compareTo(Firmware firmware) {
        return -this.version.compare(new Version(firmware.getVersion()));
    }

    private boolean hasSameThingType(Thing thing) {
        return Objects.equals((Object)this.getThingTypeUID(), (Object)thing.getThingTypeUID());
    }

    private boolean hasRequiredModel(Thing thing) {
        if (this.isModelRestricted()) {
            return Objects.equals(this.getModel(), thing.getProperties().get("modelId"));
        }
        return true;
    }

    private boolean firmwareOnThingIsHighEnough(Thing thing) {
        if (this.prerequisiteVersion == null) {
            return true;
        }
        String firmwareOnThing = thing.getProperties().get("firmwareVersion");
        return firmwareOnThing != null && new Version(firmwareOnThing).compare(this.prerequisiteVersion) >= 0;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.changelog == null ? 0 : this.changelog.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.md5Hash == null ? 0 : this.md5Hash.hashCode());
        result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
        result = 31 * result + Boolean.hashCode(this.modelRestricted);
        result = 31 * result + (this.onlineChangelog == null ? 0 : this.onlineChangelog.hashCode());
        result = 31 * result + (this.prerequisiteVersion == null ? 0 : this.prerequisiteVersion.hashCode());
        result = 31 * result + (this.thingTypeUID == null ? 0 : this.thingTypeUID.hashCode());
        result = 31 * result + (this.vendor == null ? 0 : this.vendor.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FirmwareImpl other = (FirmwareImpl)obj;
        if (this.changelog == null ? other.changelog != null : !this.changelog.equals(other.changelog)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.md5Hash == null ? other.md5Hash != null : !this.md5Hash.equals(other.md5Hash)) {
            return false;
        }
        if (this.model == null ? other.model != null : !this.model.equals(other.model)) {
            return false;
        }
        if (this.modelRestricted != other.modelRestricted) {
            return false;
        }
        if (this.onlineChangelog == null ? other.onlineChangelog != null : !this.onlineChangelog.equals(other.onlineChangelog)) {
            return false;
        }
        if (this.prerequisiteVersion == null ? other.prerequisiteVersion != null : !this.prerequisiteVersion.equals(other.prerequisiteVersion)) {
            return false;
        }
        if (this.thingTypeUID == null ? other.thingTypeUID != null : !this.thingTypeUID.equals((Object)other.thingTypeUID)) {
            return false;
        }
        if (this.vendor == null ? other.vendor != null : !this.vendor.equals(other.vendor)) {
            return false;
        }
        if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public String toString() {
        return "FirmwareImpl [thingTypeUID=" + (Object)((Object)this.thingTypeUID) + ", vendor=" + this.vendor + ", model=" + this.model + ", modelRestricted=" + this.modelRestricted + ", description=" + this.description + ", version=" + this.version + ", prerequisiteVersion=" + this.prerequisiteVersion + ", changelog=" + this.changelog + ", onlineChangelog=" + this.onlineChangelog + ", md5Hash=" + this.md5Hash + ", properties=" + this.properties + "]";
    }

    private static class Version {
        private static final int NO_INT = -1;
        private final String versionString;
        private final String[] parts;

        private Version(String versionString) {
            this.versionString = versionString;
            this.parts = versionString.split("-|_|\\.");
        }

        private int compare(@Nullable Version theVersion) {
            if (theVersion == null) {
                return 1;
            }
            int max = Math.max(this.parts.length, theVersion.parts.length);
            int i = 0;
            while (i < max) {
                String partA = i < this.parts.length ? this.parts[i] : null;
                String partB = i < theVersion.parts.length ? theVersion.parts[i] : null;
                Integer intA = partA != null && this.isInt(partA) ? Integer.parseInt(partA) : -1;
                Integer intB = partB != null && this.isInt(partB) ? Integer.parseInt(partB) : -1;
                if (intA != -1 && intB != -1) {
                    if (intA < intB) {
                        return -1;
                    }
                    if (intA > intB) {
                        return 1;
                    }
                } else if (partA == null || partB == null) {
                    if (partA == null) {
                        return -1;
                    }
                    if (partB == null) {
                        return 1;
                    }
                } else {
                    int result = partA.compareTo(partB);
                    if (result != 0) {
                        return result;
                    }
                }
                ++i;
            }
            return 0;
        }

        private boolean isInt(String s) {
            return s.matches("^-?\\d+$");
        }

        public String toString() {
            return this.versionString;
        }

        public int hashCode() {
            return this.versionString.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (other == null) {
                return false;
            }
            if (!(other instanceof Version)) {
                return false;
            }
            return Objects.equals(this.versionString, ((Version)other).versionString);
        }
    }
}

