/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.internal.i18n;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.thing.i18n.ChannelTypeI18nLocalizationService;
import org.eclipse.smarthome.core.thing.type.ChannelDefinition;
import org.eclipse.smarthome.core.thing.type.ChannelDefinitionBuilder;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.ChannelTypeRegistry;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;
import org.osgi.framework.Bundle;

@NonNullByDefault
public class ChannelI18nUtil {
    private final ChannelTypeI18nLocalizationService channelTypeI18nLocalizationService;
    private final ChannelTypeRegistry channelTypeRegistry;

    public ChannelI18nUtil(ChannelTypeI18nLocalizationService channelTypeI18nLocalizationService, ChannelTypeRegistry channelTypeRegistry) {
        this.channelTypeI18nLocalizationService = channelTypeI18nLocalizationService;
        this.channelTypeRegistry = channelTypeRegistry;
    }

    public List<ChannelDefinition> createLocalizedChannelDefinitions(Bundle bundle, List<ChannelDefinition> channelDefinitions, Function<ChannelDefinition, @Nullable String> channelLabelResolver, Function<ChannelDefinition, @Nullable String> channelDescriptionResolver, @Nullable Locale locale) {
        ArrayList<ChannelDefinition> localizedChannelDefinitions = new ArrayList<ChannelDefinition>(channelDefinitions.size());
        for (ChannelDefinition channelDefinition : channelDefinitions) {
            ChannelTypeUID channelTypeUID;
            ChannelType channelType;
            ChannelDefinitionBuilder builder = new ChannelDefinitionBuilder(channelDefinition);
            String channelLabel = channelLabelResolver.apply(channelDefinition);
            String channelDescription = channelDescriptionResolver.apply(channelDefinition);
            if ((channelLabel == null || channelDescription == null) && (channelType = this.channelTypeRegistry.getChannelType(channelTypeUID = channelDefinition.getChannelTypeUID(), locale)) != null) {
                ChannelType localizedChannelType = this.channelTypeI18nLocalizationService.createLocalizedChannelType(bundle, channelType, locale);
                if (channelLabel == null) {
                    channelLabel = localizedChannelType.getLabel();
                }
                if (channelDescription == null) {
                    channelDescription = localizedChannelType.getDescription();
                }
            }
            builder.withLabel(channelLabel);
            builder.withDescription(channelDescription);
            localizedChannelDefinitions.add(builder.build());
        }
        return localizedChannelDefinitions;
    }
}

