/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.thing.type.ChannelGroupType;
import org.eclipse.smarthome.core.thing.type.ChannelGroupTypeProvider;
import org.eclipse.smarthome.core.thing.type.ChannelGroupTypeUID;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@NonNullByDefault
@Component(service={ChannelGroupTypeRegistry.class})
public class ChannelGroupTypeRegistry {
    private final List<ChannelGroupTypeProvider> channelGroupTypeProviders = new CopyOnWriteArrayList<ChannelGroupTypeProvider>();

    public List<ChannelGroupType> getChannelGroupTypes() {
        return this.getChannelGroupTypes(null);
    }

    public List<ChannelGroupType> getChannelGroupTypes(@Nullable Locale locale) {
        ArrayList<ChannelGroupType> channelGroupTypes = new ArrayList<ChannelGroupType>();
        for (ChannelGroupTypeProvider channelTypeProvider : this.channelGroupTypeProviders) {
            channelGroupTypes.addAll(channelTypeProvider.getChannelGroupTypes(locale));
        }
        return Collections.unmodifiableList(channelGroupTypes);
    }

    public @Nullable ChannelGroupType getChannelGroupType(@Nullable ChannelGroupTypeUID channelGroupTypeUID) {
        return this.getChannelGroupType(channelGroupTypeUID, null);
    }

    public @Nullable ChannelGroupType getChannelGroupType(@Nullable ChannelGroupTypeUID channelGroupTypeUID, @Nullable Locale locale) {
        if (channelGroupTypeUID == null) {
            return null;
        }
        for (ChannelGroupTypeProvider channelTypeProvider : this.channelGroupTypeProviders) {
            ChannelGroupType channelGroupType = channelTypeProvider.getChannelGroupType(channelGroupTypeUID, locale);
            if (channelGroupType == null) continue;
            return channelGroupType;
        }
        return null;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addChannelGroupTypeProvider(ChannelGroupTypeProvider channelGroupTypeProvider) {
        this.channelGroupTypeProviders.add(channelGroupTypeProvider);
    }

    protected void removeChannelGroupTypeProvider(ChannelGroupTypeProvider channelGroupTypeProvider) {
        this.channelGroupTypeProviders.remove(channelGroupTypeProvider);
    }
}

