/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.items.events;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.core.events.AbstractEventFactory;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventFactory;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.dto.ItemDTO;
import org.eclipse.smarthome.core.items.dto.ItemDTOMapper;
import org.eclipse.smarthome.core.items.events.GroupItemStateChangedEvent;
import org.eclipse.smarthome.core.items.events.ItemAddedEvent;
import org.eclipse.smarthome.core.items.events.ItemCommandEvent;
import org.eclipse.smarthome.core.items.events.ItemRemovedEvent;
import org.eclipse.smarthome.core.items.events.ItemStateChangedEvent;
import org.eclipse.smarthome.core.items.events.ItemStateEvent;
import org.eclipse.smarthome.core.items.events.ItemStatePredictedEvent;
import org.eclipse.smarthome.core.items.events.ItemUpdatedEvent;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.Type;
import org.eclipse.smarthome.core.types.UnDefType;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={EventFactory.class})
public class ItemEventFactory
extends AbstractEventFactory {
    private static final String TYPE_POSTFIX = "Type";
    private static final String CORE_LIBRARY_PACKAGE = "org.eclipse.smarthome.core.library.types.";
    private static final String ITEM_COMAND_EVENT_TOPIC = "smarthome/items/{itemName}/command";
    private static final String ITEM_STATE_EVENT_TOPIC = "smarthome/items/{itemName}/state";
    private static final String ITEM_STATE_PREDICTED_EVENT_TOPIC = "smarthome/items/{itemName}/statepredicted";
    private static final String ITEM_STATE_CHANGED_EVENT_TOPIC = "smarthome/items/{itemName}/statechanged";
    private static final String GROUPITEM_STATE_CHANGED_EVENT_TOPIC = "smarthome/items/{itemName}/{memberName}/statechanged";
    private static final String ITEM_ADDED_EVENT_TOPIC = "smarthome/items/{itemName}/added";
    private static final String ITEM_REMOVED_EVENT_TOPIC = "smarthome/items/{itemName}/removed";
    private static final String ITEM_UPDATED_EVENT_TOPIC = "smarthome/items/{itemName}/updated";

    public ItemEventFactory() {
        super(Stream.of(ItemCommandEvent.TYPE, ItemStateEvent.TYPE, ItemStatePredictedEvent.TYPE, ItemStateChangedEvent.TYPE, ItemAddedEvent.TYPE, ItemUpdatedEvent.TYPE, ItemRemovedEvent.TYPE, GroupItemStateChangedEvent.TYPE).collect(Collectors.toSet()));
    }

    @Override
    protected Event createEventByType(String eventType, String topic, String payload, String source) throws Exception {
        Event event = null;
        if (eventType.equals(ItemCommandEvent.TYPE)) {
            event = this.createCommandEvent(topic, payload, source);
        } else if (eventType.equals(ItemStateEvent.TYPE)) {
            event = this.createStateEvent(topic, payload, source);
        } else if (eventType.equals(ItemStatePredictedEvent.TYPE)) {
            event = this.createStatePredictedEvent(topic, payload, source);
        } else if (eventType.equals(ItemStateChangedEvent.TYPE)) {
            event = this.createStateChangedEvent(topic, payload);
        } else if (eventType.equals(ItemAddedEvent.TYPE)) {
            event = this.createAddedEvent(topic, payload);
        } else if (eventType.equals(ItemUpdatedEvent.TYPE)) {
            event = this.createUpdatedEvent(topic, payload);
        } else if (eventType.equals(ItemRemovedEvent.TYPE)) {
            event = this.createRemovedEvent(topic, payload);
        } else if (eventType.equals(GroupItemStateChangedEvent.TYPE)) {
            event = this.createGroupStateChangedEvent(topic, payload);
        }
        return event;
    }

    private Event createGroupStateChangedEvent(String topic, String payload) {
        String itemName = this.getItemName(topic);
        String memberName = this.getMemberName(topic);
        ItemStateChangedEventPayloadBean bean = ItemEventFactory.deserializePayload(payload, ItemStateChangedEventPayloadBean.class);
        State state = this.getState(bean.getType(), bean.getValue());
        State oldState = this.getState(bean.getOldType(), bean.getOldValue());
        return new GroupItemStateChangedEvent(topic, payload, itemName, memberName, state, oldState);
    }

    private Event createCommandEvent(String topic, String payload, String source) {
        String itemName = this.getItemName(topic);
        ItemEventPayloadBean bean = ItemEventFactory.deserializePayload(payload, ItemEventPayloadBean.class);
        Command command = this.parseType(bean.getType(), bean.getValue(), Command.class);
        return new ItemCommandEvent(topic, payload, itemName, command, source);
    }

    private Event createStateEvent(String topic, String payload, String source) {
        String itemName = this.getItemName(topic);
        ItemEventPayloadBean bean = ItemEventFactory.deserializePayload(payload, ItemEventPayloadBean.class);
        State state = this.getState(bean.getType(), bean.getValue());
        return new ItemStateEvent(topic, payload, itemName, state, source);
    }

    private Event createStatePredictedEvent(String topic, String payload, String source) {
        String itemName = this.getItemName(topic);
        ItemStatePredictedEventPayloadBean bean = ItemEventFactory.deserializePayload(payload, ItemStatePredictedEventPayloadBean.class);
        State state = this.getState(bean.getPredictedType(), bean.getPredictedValue());
        return new ItemStatePredictedEvent(topic, payload, itemName, state, bean.isConfirmation());
    }

    private Event createStateChangedEvent(String topic, String payload) {
        String itemName = this.getItemName(topic);
        ItemStateChangedEventPayloadBean bean = ItemEventFactory.deserializePayload(payload, ItemStateChangedEventPayloadBean.class);
        State state = this.getState(bean.getType(), bean.getValue());
        State oldState = this.getState(bean.getOldType(), bean.getOldValue());
        return new ItemStateChangedEvent(topic, payload, itemName, state, oldState);
    }

    private State getState(String type, String value) {
        return this.parseType(type, value, State.class);
    }

    private String getItemName(String topic) {
        String[] topicElements = this.getTopicElements(topic);
        if (topicElements.length < 4) {
            throw new IllegalArgumentException("Event creation failed, invalid topic: " + topic);
        }
        return topicElements[2];
    }

    private String getMemberName(String topic) {
        String[] topicElements = this.getTopicElements(topic);
        if (topicElements.length < 5) {
            throw new IllegalArgumentException("Event creation failed, invalid topic: " + topic);
        }
        return topicElements[3];
    }

    private <T> T parseType(String typeName, String valueToParse, Class<T> desiredClass) {
        Object parsedObject = null;
        String simpleClassName = String.valueOf(typeName) + TYPE_POSTFIX;
        parsedObject = this.parseSimpleClassName(simpleClassName, valueToParse);
        if (parsedObject == null || !desiredClass.isAssignableFrom(parsedObject.getClass())) {
            String parsedObjectClassName = parsedObject != null ? parsedObject.getClass().getName() : "<undefined>";
            throw new IllegalArgumentException("Error parsing simpleClasssName '" + simpleClassName + "' with value '" + valueToParse + "'. Desired type was '" + desiredClass.getName() + "' but got '" + parsedObjectClassName + "'.");
        }
        return desiredClass.cast(parsedObject);
    }

    private Object parseSimpleClassName(String simpleClassName, String valueToParse) {
        if (simpleClassName.equals(UnDefType.class.getSimpleName())) {
            return UnDefType.valueOf(valueToParse);
        }
        if (simpleClassName.equals(RefreshType.class.getSimpleName())) {
            return RefreshType.valueOf(valueToParse);
        }
        try {
            Class<?> stateClass = Class.forName(CORE_LIBRARY_PACKAGE + simpleClassName);
            Method valueOfMethod = stateClass.getMethod("valueOf", String.class);
            return valueOfMethod.invoke(null, valueToParse);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Error getting class for simple name: '" + simpleClassName + "' using package name '" + CORE_LIBRARY_PACKAGE + "'.", e);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalStateException("Error getting method #valueOf(String) of class 'org.eclipse.smarthome.core.library.types." + simpleClassName + "'.", e);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalStateException("Error invoking #valueOf(String) on class 'org.eclipse.smarthome.core.library.types." + simpleClassName + "' with value '" + valueToParse + "'.", e);
        }
    }

    private Event createAddedEvent(String topic, String payload) {
        ItemDTO itemDTO = ItemEventFactory.deserializePayload(payload, ItemDTO.class);
        return new ItemAddedEvent(topic, payload, itemDTO);
    }

    private Event createRemovedEvent(String topic, String payload) {
        ItemDTO itemDTO = ItemEventFactory.deserializePayload(payload, ItemDTO.class);
        return new ItemRemovedEvent(topic, payload, itemDTO);
    }

    private Event createUpdatedEvent(String topic, String payload) {
        ItemDTO[] itemDTOs = ItemEventFactory.deserializePayload(payload, ItemDTO[].class);
        if (itemDTOs.length != 2) {
            throw new IllegalArgumentException("ItemUpdateEvent creation failed, invalid payload: " + payload);
        }
        return new ItemUpdatedEvent(topic, payload, itemDTOs[0], itemDTOs[1]);
    }

    public static ItemCommandEvent createCommandEvent(String itemName, Command command, String source) {
        ItemEventFactory.assertValidArguments(itemName, command, "command");
        String topic = ItemEventFactory.buildTopic(ITEM_COMAND_EVENT_TOPIC, itemName);
        ItemEventPayloadBean bean = new ItemEventPayloadBean(ItemEventFactory.getCommandType(command), command.toString());
        String payload = ItemEventFactory.serializePayload(bean);
        return new ItemCommandEvent(topic, payload, itemName, command, source);
    }

    public static ItemCommandEvent createCommandEvent(String itemName, Command command) {
        return ItemEventFactory.createCommandEvent(itemName, command, null);
    }

    public static ItemStateEvent createStateEvent(String itemName, State state, String source) {
        ItemEventFactory.assertValidArguments(itemName, state, "state");
        String topic = ItemEventFactory.buildTopic(ITEM_STATE_EVENT_TOPIC, itemName);
        ItemEventPayloadBean bean = new ItemEventPayloadBean(ItemEventFactory.getStateType(state), state.toFullString());
        String payload = ItemEventFactory.serializePayload(bean);
        return new ItemStateEvent(topic, payload, itemName, state, source);
    }

    public static ItemStateEvent createStateEvent(String itemName, State state) {
        return ItemEventFactory.createStateEvent(itemName, state, null);
    }

    public static ItemStatePredictedEvent createStatePredictedEvent(String itemName, State state, boolean isConfirmation) {
        ItemEventFactory.assertValidArguments(itemName, state, "state");
        String topic = ItemEventFactory.buildTopic(ITEM_STATE_PREDICTED_EVENT_TOPIC, itemName);
        ItemStatePredictedEventPayloadBean bean = new ItemStatePredictedEventPayloadBean(ItemEventFactory.getStateType(state), state.toFullString(), isConfirmation);
        String payload = ItemEventFactory.serializePayload(bean);
        return new ItemStatePredictedEvent(topic, payload, itemName, state, isConfirmation);
    }

    public static ItemStateChangedEvent createStateChangedEvent(String itemName, State newState, State oldState) {
        ItemEventFactory.assertValidArguments(itemName, newState, "state");
        String topic = ItemEventFactory.buildTopic(ITEM_STATE_CHANGED_EVENT_TOPIC, itemName);
        ItemStateChangedEventPayloadBean bean = new ItemStateChangedEventPayloadBean(ItemEventFactory.getStateType(newState), newState.toFullString(), ItemEventFactory.getStateType(oldState), oldState.toFullString());
        String payload = ItemEventFactory.serializePayload(bean);
        return new ItemStateChangedEvent(topic, payload, itemName, newState, oldState);
    }

    public static GroupItemStateChangedEvent createGroupStateChangedEvent(String itemName, String memberName, State newState, State oldState) {
        ItemEventFactory.assertValidArguments(itemName, memberName, newState, "state");
        String topic = ItemEventFactory.buildGroupTopic(GROUPITEM_STATE_CHANGED_EVENT_TOPIC, itemName, memberName);
        ItemStateChangedEventPayloadBean bean = new ItemStateChangedEventPayloadBean(ItemEventFactory.getStateType(newState), newState.toFullString(), ItemEventFactory.getStateType(oldState), oldState.toFullString());
        String payload = ItemEventFactory.serializePayload(bean);
        return new GroupItemStateChangedEvent(topic, payload, itemName, memberName, newState, oldState);
    }

    public static ItemAddedEvent createAddedEvent(Item item) {
        ItemEventFactory.assertValidArgument(item, "item");
        String topic = ItemEventFactory.buildTopic(ITEM_ADDED_EVENT_TOPIC, item.getName());
        ItemDTO itemDTO = ItemEventFactory.map(item);
        String payload = ItemEventFactory.serializePayload(itemDTO);
        return new ItemAddedEvent(topic, payload, itemDTO);
    }

    public static ItemRemovedEvent createRemovedEvent(Item item) {
        ItemEventFactory.assertValidArgument(item, "item");
        String topic = ItemEventFactory.buildTopic(ITEM_REMOVED_EVENT_TOPIC, item.getName());
        ItemDTO itemDTO = ItemEventFactory.map(item);
        String payload = ItemEventFactory.serializePayload(itemDTO);
        return new ItemRemovedEvent(topic, payload, itemDTO);
    }

    public static ItemUpdatedEvent createUpdateEvent(Item item, Item oldItem) {
        ItemEventFactory.assertValidArgument(item, "item");
        ItemEventFactory.assertValidArgument(oldItem, "oldItem");
        String topic = ItemEventFactory.buildTopic(ITEM_UPDATED_EVENT_TOPIC, item.getName());
        ItemDTO itemDTO = ItemEventFactory.map(item);
        ItemDTO oldItemDTO = ItemEventFactory.map(oldItem);
        LinkedList<ItemDTO> itemDTOs = new LinkedList<ItemDTO>();
        itemDTOs.add(itemDTO);
        itemDTOs.add(oldItemDTO);
        String payload = ItemEventFactory.serializePayload(itemDTOs);
        return new ItemUpdatedEvent(topic, payload, itemDTO, oldItemDTO);
    }

    private static String buildTopic(String topic, String itemName) {
        return topic.replace("{itemName}", itemName);
    }

    private static String buildGroupTopic(String topic, String itemName, String memberName) {
        return ItemEventFactory.buildTopic(topic, itemName).replace("{memberName}", memberName);
    }

    private static ItemDTO map(Item item) {
        return ItemDTOMapper.map(item);
    }

    private static String getStateType(State state) {
        return StringUtils.removeEnd((String)state.getClass().getSimpleName(), (String)TYPE_POSTFIX);
    }

    private static String getCommandType(Command command) {
        return StringUtils.removeEnd((String)command.getClass().getSimpleName(), (String)TYPE_POSTFIX);
    }

    private static void assertValidArguments(String itemName, Type type, String typeArgumentName) {
        ItemEventFactory.checkNotNullOrEmpty(itemName, "itemName");
        ItemEventFactory.checkNotNull(type, typeArgumentName);
    }

    private static void assertValidArguments(String itemName, String memberName, Type type, String typeArgumentName) {
        ItemEventFactory.checkNotNullOrEmpty(itemName, "itemName");
        ItemEventFactory.checkNotNullOrEmpty(memberName, "memberName");
        ItemEventFactory.checkNotNull(type, typeArgumentName);
    }

    private static void assertValidArgument(Item item, String argumentName) {
        ItemEventFactory.checkNotNull(item, argumentName);
    }

    private static class ItemEventPayloadBean {
        private String type;
        private String value;

        protected ItemEventPayloadBean() {
        }

        public ItemEventPayloadBean(String type, String value) {
            this.type = type;
            this.value = value;
        }

        public String getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }
    }

    private static class ItemStateChangedEventPayloadBean {
        private String type;
        private String value;
        private String oldType;
        private String oldValue;

        protected ItemStateChangedEventPayloadBean() {
        }

        public ItemStateChangedEventPayloadBean(String type, String value, String oldType, String oldValue) {
            this.type = type;
            this.value = value;
            this.oldType = oldType;
            this.oldValue = oldValue;
        }

        public String getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public String getOldType() {
            return this.oldType;
        }

        public String getOldValue() {
            return this.oldValue;
        }
    }

    private static class ItemStatePredictedEventPayloadBean {
        private String predictedType;
        private String predictedValue;
        private boolean isConfirmation;

        protected ItemStatePredictedEventPayloadBean() {
        }

        public ItemStatePredictedEventPayloadBean(String predictedType, String predictedValue, boolean isConfirmation) {
            this.predictedType = predictedType;
            this.predictedValue = predictedValue;
            this.isConfirmation = isConfirmation;
        }

        public String getPredictedType() {
            return this.predictedType;
        }

        public String getPredictedValue() {
            return this.predictedValue;
        }

        public boolean isConfirmation() {
            return this.isConfirmation;
        }
    }
}

