/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.library.types;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.PrimitiveType;
import org.eclipse.smarthome.core.types.State;

@NonNullByDefault
public class DateTimeType
implements PrimitiveType,
State,
Command {
    public static final String DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String DATE_PATTERN_WITH_TZ = "yyyy-MM-dd'T'HH:mm:ssz";
    public static final String DATE_PATTERN_WITH_TZ_AND_MS = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final String DATE_PATTERN_WITH_TZ_AND_MS_GENERAL = "yyyy-MM-dd'T'HH:mm:ss.SSSz";
    public static final String DATE_PATTERN_WITH_TZ_AND_MS_ISO = "yyyy-MM-dd'T'HH:mm:ss.SSSX";
    private static final String DATE_PARSE_PATTERN_WITHOUT_TZ = "yyyy-MM-dd'T'HH:mm[:ss[.SSS]]";
    private static final String DATE_PARSE_PATTERN_WITH_TZ = "yyyy-MM-dd'T'HH:mm[:ss[.SSS]]z";
    private static final String DATE_PARSE_PATTERN_WITH_TZ_RFC = "yyyy-MM-dd'T'HH:mm[:ss[.SSS]]Z";
    private static final String DATE_PARSE_PATTERN_WITH_TZ_ISO = "yyyy-MM-dd'T'HH:mm[:ss[.SSS]]X";
    private ZonedDateTime zonedDateTime;
    private final DateTimeFormatter formatter;
    private final DateTimeFormatter formatterTz;
    private final DateTimeFormatter formatterTzRFC;
    private final DateTimeFormatter formatterTzIso;

    @Deprecated
    public DateTimeType(Calendar calendar) {
        this.formatter = DateTimeFormatter.ofPattern(DATE_PARSE_PATTERN_WITHOUT_TZ);
        this.formatterTz = DateTimeFormatter.ofPattern(DATE_PARSE_PATTERN_WITH_TZ);
        this.formatterTzRFC = DateTimeFormatter.ofPattern(DATE_PARSE_PATTERN_WITH_TZ_RFC);
        this.formatterTzIso = DateTimeFormatter.ofPattern(DATE_PARSE_PATTERN_WITH_TZ_ISO);
        this.zonedDateTime = ZonedDateTime.ofInstant(calendar.toInstant(), TimeZone.getDefault().toZoneId()).withFixedOffsetZone();
    }

    public DateTimeType() {
        this(ZonedDateTime.now());
    }

    public DateTimeType(ZonedDateTime zoned) {
        this.formatter = DateTimeFormatter.ofPattern(DATE_PARSE_PATTERN_WITHOUT_TZ);
        this.formatterTz = DateTimeFormatter.ofPattern(DATE_PARSE_PATTERN_WITH_TZ);
        this.formatterTzRFC = DateTimeFormatter.ofPattern(DATE_PARSE_PATTERN_WITH_TZ_RFC);
        this.formatterTzIso = DateTimeFormatter.ofPattern(DATE_PARSE_PATTERN_WITH_TZ_ISO);
        this.zonedDateTime = ZonedDateTime.from(zoned).withFixedOffsetZone();
    }

    public DateTimeType(String zonedValue) {
        ZonedDateTime date;
        block7: {
            this.formatter = DateTimeFormatter.ofPattern(DATE_PARSE_PATTERN_WITHOUT_TZ);
            this.formatterTz = DateTimeFormatter.ofPattern(DATE_PARSE_PATTERN_WITH_TZ);
            this.formatterTzRFC = DateTimeFormatter.ofPattern(DATE_PARSE_PATTERN_WITH_TZ_RFC);
            this.formatterTzIso = DateTimeFormatter.ofPattern(DATE_PARSE_PATTERN_WITH_TZ_ISO);
            date = null;
            try {
                try {
                    date = this.parse(zonedValue);
                }
                catch (DateTimeParseException dateTimeParseException) {
                    try {
                        date = this.parse("1970-01-01T" + zonedValue);
                    }
                    catch (DateTimeParseException dateTimeParseException2) {
                        if (zonedValue.length() == 10) {
                            date = this.parse(String.valueOf(zonedValue) + "T00:00:00");
                            break block7;
                        }
                        date = this.parse(String.valueOf(zonedValue.substring(0, 10)) + "T00:00:00" + zonedValue.substring(10));
                    }
                }
            }
            catch (DateTimeParseException invalidFormatException) {
                throw new IllegalArgumentException(String.valueOf(zonedValue) + " is not in a valid format.", invalidFormatException);
            }
        }
        this.zonedDateTime = date;
    }

    @Deprecated
    public Calendar getCalendar() {
        return GregorianCalendar.from(this.zonedDateTime);
    }

    public ZonedDateTime getZonedDateTime() {
        return this.zonedDateTime;
    }

    public static DateTimeType valueOf(String value) {
        return new DateTimeType(value);
    }

    @Override
    public String format(@Nullable String pattern) {
        if (pattern == null) {
            return DateTimeFormatter.ofPattern(DATE_PATTERN).format(this.zonedDateTime);
        }
        return String.format(pattern, this.zonedDateTime);
    }

    public String format(Locale locale, String pattern) {
        return String.format(locale, pattern, this.zonedDateTime);
    }

    public String toString() {
        return this.toFullString();
    }

    @Override
    public String toFullString() {
        return this.zonedDateTime.format(this.formatterTzRFC);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.getZonedDateTime() == null ? 0 : this.getZonedDateTime().hashCode());
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateTimeType other = (DateTimeType)obj;
        return !(this.zonedDateTime == null ? other.zonedDateTime != null : this.zonedDateTime.compareTo(other.zonedDateTime) != 0);
    }

    private ZonedDateTime parse(String value) throws DateTimeParseException {
        ZonedDateTime date = null;
        try {
            date = ZonedDateTime.parse(value, this.formatterTzRFC);
        }
        catch (DateTimeParseException dateTimeParseException) {
            try {
                date = ZonedDateTime.parse(value, this.formatterTzIso);
            }
            catch (DateTimeParseException dateTimeParseException2) {
                try {
                    date = ZonedDateTime.parse(value, this.formatterTz);
                }
                catch (DateTimeParseException dateTimeParseException3) {
                    LocalDateTime localDateTime = LocalDateTime.parse(value, this.formatter);
                    date = ZonedDateTime.of(localDateTime, ZoneId.systemDefault());
                }
            }
        }
        return date;
    }
}

