/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.service;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.common.ThreadPoolManager;
import org.eclipse.smarthome.core.service.AbstractWatchService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchQueueReader
implements Runnable {
    private static final String THREAD_POOL_NAME = "file-processing";
    private static final int PROCESSING_DELAY = 1000;
    protected final Logger logger = LoggerFactory.getLogger(WatchQueueReader.class);
    private final ScheduledExecutorService scheduler = ThreadPoolManager.getScheduledPool("file-processing");
    protected WatchService watchService;
    private final Map<WatchKey, Path> registeredKeys = new HashMap<WatchKey, Path>();
    private final Map<WatchKey, AbstractWatchService> keyToService = new HashMap<WatchKey, AbstractWatchService>();
    private final Map<AbstractWatchService, Map<Path, byte[]>> hashes = new HashMap<AbstractWatchService, Map<Path, byte[]>>();
    private final Map<WatchKey, @Nullable Map<Path, @Nullable ScheduledFuture<?>>> futures = new ConcurrentHashMap();
    private Thread qr;
    private static final WatchQueueReader INSTANCE = new WatchQueueReader();

    static <T> WatchEvent<T> cast(WatchEvent<?> event) {
        return event;
    }

    public static WatchQueueReader getInstance() {
        return INSTANCE;
    }

    private WatchQueueReader() {
    }

    protected void customizeWatchQueueReader(AbstractWatchService watchService, Path toWatch, boolean watchSubDirectories) {
        try {
            if (watchSubDirectories) {
                this.registerWithSubDirectories(watchService, toWatch);
            } else {
                this.registerDirectoryInternal(watchService, watchService.getWatchEventKinds(toWatch), toWatch);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            this.logger.debug("Not watching folder '{}' as it does not exist.", (Object)toWatch);
        }
        catch (IOException e) {
            this.logger.warn("Cannot customize folder watcher for folder '{}'", (Object)toWatch, (Object)e);
        }
    }

    private void registerWithSubDirectories(final AbstractWatchService watchService, Path toWatch) throws IOException {
        Files.walkFileTree(toWatch, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path subDir, BasicFileAttributes attrs) throws IOException {
                WatchEvent.Kind[] kinds = watchService.getWatchEventKinds(subDir);
                if (kinds != null) {
                    WatchQueueReader.this.registerDirectoryInternal(watchService, kinds, subDir);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                if (exc instanceof AccessDeniedException) {
                    WatchQueueReader.this.logger.warn("Access to folder '{}' was denied, therefore skipping it.", (Object)file.toAbsolutePath().toString());
                }
                return FileVisitResult.SKIP_SUBTREE;
            }
        });
    }

    private synchronized void registerDirectoryInternal(AbstractWatchService service, WatchEvent.Kind<?>[] kinds, Path directory) {
        if (this.watchService == null) {
            try {
                this.watchService = FileSystems.getDefault().newWatchService();
                this.qr = new Thread((Runnable)this, "Dir Watcher");
                this.qr.start();
            }
            catch (IOException e) {
                this.logger.debug("The directory '{}' was not registered in the watch service", (Object)directory, (Object)e);
                return;
            }
        }
        WatchKey registrationKey = null;
        try {
            registrationKey = directory.register(this.watchService, kinds);
        }
        catch (IOException e) {
            this.logger.debug("The directory '{}' was not registered in the watch service: {}", (Object)directory, (Object)e.getMessage());
        }
        if (registrationKey != null) {
            this.registeredKeys.put(registrationKey, directory);
            this.keyToService.put(registrationKey, service);
        } else {
            this.logger.debug("The directory '{}' was not registered in the watch service", (Object)directory);
        }
    }

    public synchronized void stopWatchService(AbstractWatchService service) {
        if (this.watchService != null) {
            LinkedList<WatchKey> keys = new LinkedList<WatchKey>();
            for (WatchKey key : this.keyToService.keySet()) {
                if (this.keyToService.get(key) != service) continue;
                keys.add(key);
            }
            if (keys.size() == this.keyToService.size()) {
                try {
                    this.watchService.close();
                }
                catch (IOException e) {
                    this.logger.warn("Cannot deactivate folder watcher", (Throwable)e);
                }
                this.watchService = null;
                this.keyToService.clear();
                this.registeredKeys.clear();
                this.hashes.clear();
                this.futures.values().forEach(keyFutures -> keyFutures.values().forEach(future -> {
                    boolean bl = future.cancel(true);
                }));
                this.futures.clear();
            } else {
                for (WatchKey key : keys) {
                    key.cancel();
                    this.keyToService.remove(key);
                    this.registeredKeys.remove(key);
                    this.hashes.remove(service);
                    Map<Path, @Nullable ScheduledFuture<?>> keyFutures2 = this.futures.remove(key);
                    if (keyFutures2 == null) continue;
                    keyFutures2.values().forEach(future -> {
                        boolean bl = future.cancel(true);
                    });
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (true) {
                WatchKey key;
                try {
                    key = this.watchService.take();
                }
                catch (InterruptedException exc) {
                    this.logger.info("Caught InterruptedException: {}", (Object)exc.getLocalizedMessage());
                    return;
                }
                for (WatchEvent<?> event : key.pollEvents()) {
                    AbstractWatchService service;
                    WatchEvent.Kind<?> kind = event.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW) {
                        this.logger.warn("Found an event of kind 'OVERFLOW': {}. File system changes might have been missed.", event);
                        continue;
                    }
                    Path resolvedPath = this.resolvePath(key, event);
                    if (resolvedPath == null) continue;
                    WatchQueueReader watchQueueReader = this;
                    synchronized (watchQueueReader) {
                        service = this.keyToService.get(key);
                    }
                    if (service == null) continue;
                    File f = resolvedPath.toFile();
                    if (kind == StandardWatchEventKinds.ENTRY_MODIFY && f.isDirectory()) {
                        this.logger.trace("Skipping modification event for directory: {}", (Object)f);
                    } else if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                        this.processModificationEvent(key, event, resolvedPath, service);
                    } else {
                        service.processWatchEvent(event, kind, resolvedPath);
                    }
                    if (kind == StandardWatchEventKinds.ENTRY_CREATE && f.isDirectory() && service.watchSubDirectories() && service.getWatchEventKinds(resolvedPath) != null) {
                        this.registerDirectoryInternal(service, service.getWatchEventKinds(resolvedPath), resolvedPath);
                        continue;
                    }
                    if (kind != StandardWatchEventKinds.ENTRY_DELETE) continue;
                    WatchQueueReader watchQueueReader2 = this;
                    synchronized (watchQueueReader2) {
                        ScheduledFuture<?> future;
                        WatchKey toCancel = null;
                        for (WatchKey k : this.registeredKeys.keySet()) {
                            if (!this.registeredKeys.get(k).equals(resolvedPath)) continue;
                            toCancel = k;
                            break;
                        }
                        if (toCancel != null) {
                            this.registeredKeys.remove(toCancel);
                            this.keyToService.remove(toCancel);
                            toCancel.cancel();
                        }
                        this.forgetChecksum(service, resolvedPath);
                        Map<Path, @Nullable ScheduledFuture<?>> keyFutures = this.futures.get(key);
                        if (keyFutures != null && (future = keyFutures.remove(resolvedPath)) != null) {
                            future.cancel(true);
                        }
                    }
                }
                key.reset();
            }
        }
        catch (Exception exc) {
            this.logger.debug("ClosedWatchServiceException caught! {}. \n{} Stopping ", (Object)exc.getLocalizedMessage(), (Object)Thread.currentThread().getName());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processModificationEvent(WatchKey key, WatchEvent<?> event, Path resolvedPath, AbstractWatchService service) {
        Map<WatchKey, Map<Path, ScheduledFuture<?>>> map = this.futures;
        synchronized (map) {
            this.logger.trace("Modification event for {} ", (Object)resolvedPath);
            ScheduledFuture<?> previousFuture = this.removeScheduledJob(key, resolvedPath);
            if (previousFuture != null) {
                previousFuture.cancel(true);
                this.logger.trace("Cancelled previous for {} ", (Object)resolvedPath);
            }
            ScheduledFuture<?> future = this.scheduler.schedule(() -> {
                this.logger.trace("Executing job for {}", (Object)resolvedPath);
                ScheduledFuture<?> res = this.removeScheduledJob(key, resolvedPath);
                if (res != null) {
                    this.logger.trace("Job removed itself for {}", (Object)resolvedPath);
                } else {
                    this.logger.trace("Job couldn't find itself for {}", (Object)resolvedPath);
                }
                if (this.checkAndTrackContent(service, resolvedPath)) {
                    service.processWatchEvent(event, event.kind(), resolvedPath);
                } else {
                    this.logger.trace("File content '{}' has not changed, skipping modification event", (Object)resolvedPath);
                }
            }, 1000L, TimeUnit.MILLISECONDS);
            this.logger.trace("Scheduled processing of {}", (Object)resolvedPath);
            this.rememberScheduledJob(key, resolvedPath, future);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path resolvePath(WatchKey key, WatchEvent<?> event) {
        WatchEvent ev = WatchQueueReader.cast(event);
        Path contextPath = (Path)ev.context();
        Path baseWatchedDir = null;
        Path registeredPath = null;
        WatchQueueReader watchQueueReader = this;
        synchronized (watchQueueReader) {
            baseWatchedDir = this.keyToService.get(key).getSourcePath();
            registeredPath = this.registeredKeys.get(key);
        }
        if (registeredPath != null) {
            return registeredPath.resolve(contextPath);
        }
        this.logger.warn("Detected invalid WatchEvent '{}' and key '{}' for entry '{}' in not registered file or directory of '{}'", new Object[]{event, key, contextPath, baseWatchedDir});
        return null;
    }

    private byte[] hash(Path path) {
        MessageDigest digester;
        block13: {
            digester = MessageDigest.getInstance("SHA-256");
            if (Files.exists(path, new LinkOption[0])) break block13;
            return null;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                int read;
                byte[] buffer = new byte[4069];
                do {
                    if ((read = is.read(buffer)) <= 0) continue;
                    digester.update(buffer, 0, read);
                } while (read != -1);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return digester.digest();
        }
        catch (IOException | NoSuchAlgorithmException e) {
            this.logger.debug("Error calculating the hash of file {}", (Object)path, (Object)e);
            return null;
        }
    }

    private boolean checkAndTrackContent(AbstractWatchService service, Path resolvedPath) {
        byte[] oldHash;
        byte[] newHash = this.hash(resolvedPath);
        if (newHash == null) {
            return true;
        }
        Map<Path, byte[]> keyHashes = this.hashes.get(service);
        if (keyHashes == null) {
            keyHashes = new HashMap<Path, byte[]>();
            this.hashes.put(service, keyHashes);
        }
        return (oldHash = keyHashes.put(resolvedPath, newHash)) == null || !Arrays.equals(oldHash, newHash);
    }

    private void forgetChecksum(AbstractWatchService service, Path resolvedPath) {
        Map<Path, byte[]> keyHashes = this.hashes.get(service);
        if (keyHashes != null) {
            keyHashes.remove(resolvedPath);
        }
    }

    private Map<Path, @Nullable ScheduledFuture<?>> getKeyFutures(WatchKey key) {
        Map<Path, @Nullable ScheduledFuture<?>> keyFutures = this.futures.get(key);
        if (keyFutures == null) {
            keyFutures = new ConcurrentHashMap();
            this.futures.put(key, keyFutures);
        }
        return keyFutures;
    }

    private ScheduledFuture<?> removeScheduledJob(WatchKey key, Path resolvedPath) {
        Map<Path, @Nullable ScheduledFuture<?>> keyFutures = this.getKeyFutures(key);
        return keyFutures.remove(resolvedPath);
    }

    private void rememberScheduledJob(WatchKey key, Path resolvedPath, ScheduledFuture<?> future) {
        Map<Path, @Nullable ScheduledFuture<?>> keyFutures = this.getKeyFutures(key);
        keyFutures.put(resolvedPath, future);
    }
}

