/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.extensionservice.marketplace.internal;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.eclipse.smarthome.extensionservice.marketplace.MarketplaceExtension;
import org.eclipse.smarthome.extensionservice.marketplace.MarketplaceExtensionHandler;
import org.eclipse.smarthome.extensionservice.marketplace.MarketplaceHandlerException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class BundleExtensionHandler
implements MarketplaceExtensionHandler {
    private static final String BINDING_FILE = "installedBindingsMap.csv";
    private static final String BUNDLE_FILE = "installedBundlesMap.csv";
    private static final List<String> SUPPORTED_EXT_TYPES = Arrays.asList("binding", "voice");
    private final Logger logger = LoggerFactory.getLogger(BundleExtensionHandler.class);
    private Map<String, Long> installedBundles;
    private BundleContext bundleContext;

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> config) {
        this.bundleContext = bundleContext;
        this.installedBundles = this.loadInstalledBundlesMap();
    }

    @Deactivate
    protected void deactivate() {
        this.installedBundles = null;
        this.bundleContext = null;
    }

    @Override
    public boolean supports(MarketplaceExtension ext) {
        return SUPPORTED_EXT_TYPES.contains(ext.getType()) && ext.getPackageFormat().equals("bundle");
    }

    @Override
    public boolean isInstalled(MarketplaceExtension ext) {
        return this.installedBundles.containsKey(ext.getId());
    }

    @Override
    public void install(MarketplaceExtension ext) throws MarketplaceHandlerException {
        String url = ext.getDownloadUrl();
        try {
            Bundle bundle = this.bundleContext.installBundle(url);
            try {
                bundle.start();
            }
            catch (BundleException e) {
                this.logger.warn("Installed bundle, but failed to start it: {}", (Object)e.getMessage());
            }
            this.installedBundles.put(ext.getId(), bundle.getBundleId());
            this.persistInstalledBundlesMap(this.installedBundles);
        }
        catch (BundleException e) {
            this.logger.debug("Failed to install bundle from marketplace.", (Throwable)e);
            throw new MarketplaceHandlerException("Bundle cannot be installed: " + e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void uninstall(MarketplaceExtension ext) throws MarketplaceHandlerException {
        Long id = this.installedBundles.get(ext.getId());
        if (id == null) throw new MarketplaceHandlerException("Id not known.");
        Bundle bundle = this.bundleContext.getBundle(id.longValue());
        if (bundle != null) {
            try {
                bundle.stop();
                bundle.uninstall();
                this.installedBundles.remove(ext.getId());
                this.persistInstalledBundlesMap(this.installedBundles);
                return;
            }
            catch (BundleException e) {
                throw new MarketplaceHandlerException("Failed deinstalling bundle: " + e.getMessage());
            }
        } else {
            this.installedBundles.remove(ext.getId());
            this.persistInstalledBundlesMap(this.installedBundles);
            throw new MarketplaceHandlerException("Id not known.");
        }
    }

    private Map<String, Long> loadInstalledBundlesMap() {
        File dataFile = this.bundleContext.getDataFile(BUNDLE_FILE);
        if (dataFile != null && dataFile.exists()) {
            return this.loadInstalledBundlesFile(dataFile);
        }
        File obsoleteFile = this.bundleContext.getDataFile(BINDING_FILE);
        if (obsoleteFile != null & obsoleteFile.exists()) {
            return this.loadInstalledBundlesFile(obsoleteFile);
        }
        return new HashMap<String, Long>();
    }

    private Map<String, Long> loadInstalledBundlesFile(File dataFile) {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (FileReader reader = new FileReader(dataFile);){
                LineIterator lineIterator = IOUtils.lineIterator((Reader)reader);
                HashMap<String, Long> map = new HashMap<String, Long>();
                while (lineIterator.hasNext()) {
                    String line = lineIterator.nextLine();
                    String[] parts = line.split(";");
                    if (parts.length == 2) {
                        try {
                            map.put(parts[0], Long.valueOf(parts[1]));
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.logger.debug("Cannot parse '{}' as a number in file {} - ignoring it.", (Object)parts[1], (Object)dataFile.getName());
                        }
                        continue;
                    }
                    this.logger.debug("Invalid line in file {} - ignoring it:\n{}", (Object)dataFile.getName(), (Object)line);
                }
                return map;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            this.logger.debug("File '{}' for installed bundles does not exist.", (Object)dataFile.getName());
            return new HashMap<String, Long>();
        }
    }

    private synchronized void persistInstalledBundlesMap(Map<String, Long> map) {
        File dataFile = this.bundleContext.getDataFile(BUNDLE_FILE);
        if (dataFile != null) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (FileWriter writer = new FileWriter(dataFile);){
                    for (Map.Entry<String, Long> entry : map.entrySet()) {
                        writer.write(String.valueOf(entry.getKey()) + ";" + entry.getValue() + System.lineSeparator());
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.logger.warn("Failed writing file '{}': {}", (Object)dataFile.getName(), (Object)e.getMessage());
            }
        } else {
            this.logger.debug("System does not support bundle data files -> not persisting installed bundle info");
        }
    }
}

