/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.net.http.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.io.net.http.TlsCertificateProvider;
import org.eclipse.smarthome.io.net.http.TlsTrustManagerProvider;
import org.eclipse.smarthome.io.net.http.internal.TrustManagerUtil;

@NonNullByDefault
class TlsCertificateTrustManagerAdapter
implements TlsTrustManagerProvider {
    private final String hostname;
    private final X509ExtendedTrustManager trustManager;

    TlsCertificateTrustManagerAdapter(TlsCertificateProvider tlsCertificateProvider) {
        this.hostname = tlsCertificateProvider.getHostName();
        this.trustManager = TlsCertificateTrustManagerAdapter.trustManagerFromCertificate(this.hostname, tlsCertificateProvider.getCertificate());
    }

    @Override
    public String getHostName() {
        return this.hostname;
    }

    @Override
    public X509ExtendedTrustManager getTrustManager() {
        return this.trustManager;
    }

    private static X509ExtendedTrustManager trustManagerFromCertificate(String hostname, URL certificateUrl) {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            try {
                Throwable throwable = null;
                Object var4_7 = null;
                try (InputStream inputStream = certificateUrl.openStream();){
                    KeyStore keyStore = KeyStore.getInstance("PKCS12");
                    keyStore.load(null, null);
                    Certificate certificate = certificateFactory.generateCertificate(inputStream);
                    keyStore.setCertificateEntry(hostname, certificate);
                    return TrustManagerUtil.keyStoreToTrustManager(keyStore);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (KeyStoreException | NoSuchAlgorithmException e) {
                throw new IllegalStateException("Failed to initialize internal keystore", e);
            }
        }
        catch (IOException | CertificateException e) {
            throw new IllegalStateException("Failed to initialize TrustManager", e);
        }
    }
}

