/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.core.item;

import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.function.Predicate;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.dto.ItemDTO;
import org.eclipse.smarthome.core.items.dto.ItemDTOMapper;
import org.eclipse.smarthome.core.transform.TransformationException;
import org.eclipse.smarthome.core.transform.TransformationHelper;
import org.eclipse.smarthome.core.types.StateDescription;
import org.eclipse.smarthome.io.rest.core.internal.RESTCoreActivator;
import org.eclipse.smarthome.io.rest.core.item.EnrichedGroupItemDTO;
import org.eclipse.smarthome.io.rest.core.item.EnrichedItemDTO;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnrichedItemDTOMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnrichedItemDTOMapper.class);

    public static EnrichedItemDTO map(Item item, boolean drillDown, Predicate<Item> itemFilter, URI uri, Locale locale) {
        ItemDTO itemDTO = ItemDTOMapper.map((Item)item);
        return EnrichedItemDTOMapper.map(item, itemDTO, uri, drillDown, itemFilter, locale);
    }

    private static EnrichedItemDTO map(Item item, ItemDTO itemDTO, URI uri, boolean drillDown, Predicate<Item> itemFilter, Locale locale) {
        String state = item.getState().toFullString();
        String transformedState = EnrichedItemDTOMapper.considerTransformation(state, item, locale);
        if (transformedState != null && transformedState.equals(state)) {
            transformedState = null;
        }
        StateDescription stateDescription = EnrichedItemDTOMapper.considerTransformation(item.getStateDescription(locale));
        String link = uri != null ? String.valueOf(uri.toASCIIString()) + "items" + "/" + itemDTO.name : null;
        EnrichedItemDTO enrichedItemDTO = null;
        if (item instanceof GroupItem) {
            EnrichedItemDTO[] memberDTOs;
            GroupItem groupItem = (GroupItem)item;
            if (drillDown) {
                LinkedHashSet<EnrichedItemDTO> members = new LinkedHashSet<EnrichedItemDTO>();
                for (Item member : groupItem.getMembers()) {
                    if (itemFilter != null && !itemFilter.test(member)) continue;
                    members.add(EnrichedItemDTOMapper.map(member, drillDown, itemFilter, uri, locale));
                }
                memberDTOs = members.toArray(new EnrichedItemDTO[members.size()]);
            } else {
                memberDTOs = new EnrichedItemDTO[]{};
            }
            enrichedItemDTO = new EnrichedGroupItemDTO(itemDTO, memberDTOs, link, state, transformedState, stateDescription);
        } else {
            enrichedItemDTO = new EnrichedItemDTO(itemDTO, link, state, transformedState, stateDescription);
        }
        return enrichedItemDTO;
    }

    private static StateDescription considerTransformation(StateDescription desc) {
        if (desc == null || desc.getPattern() == null) {
            return desc;
        }
        try {
            return TransformationHelper.isTransform((String)desc.getPattern()) ? new StateDescription(desc.getMinimum(), desc.getMaximum(), desc.getStep(), "", desc.isReadOnly(), desc.getOptions()) : desc;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return desc;
        }
    }

    private static String considerTransformation(String state, Item item, Locale locale) {
        StateDescription stateDescription = item.getStateDescription(locale);
        if (stateDescription != null && stateDescription.getPattern() != null && state != null) {
            try {
                return TransformationHelper.transform((BundleContext)RESTCoreActivator.getBundleContext(), (String)stateDescription.getPattern(), (String)state.toString());
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                return state;
            }
            catch (TransformationException e) {
                LOGGER.warn("Failed transforming the state '{}' on item '{}' with pattern '{}': {}", new Object[]{state, item.getName(), stateDescription.getPattern(), e.getMessage()});
                return state;
            }
        }
        return state;
    }
}

