/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.mdns.internal;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.smarthome.core.net.HttpServiceUtil;
import org.eclipse.smarthome.io.transport.mdns.MDNSService;
import org.eclipse.smarthome.io.transport.mdns.ServiceDescription;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true, configurationPid="org.eclipse.smarthome.mdns", property={"service.pid=org.eclipse.smarthome.mdns"})
public class MDNSAnnouncer {
    private int httpSSLPort;
    private int httpPort;
    private String mdnsName;
    private MDNSService mdnsService;

    @Reference(policy=ReferencePolicy.DYNAMIC)
    public void setMDNSService(MDNSService mdnsService) {
        this.mdnsService = mdnsService;
    }

    public void unsetMDNSService(MDNSService mdnsService) {
        this.mdnsService = null;
    }

    @Activate
    public void activate(BundleContext bundleContext, Map<String, Object> properties) {
        if (!"false".equalsIgnoreCase((String)properties.get("enabled")) && this.mdnsService != null) {
            this.mdnsName = bundleContext.getProperty("mdnsName");
            if (this.mdnsName == null) {
                this.mdnsName = "smarthome";
            }
            try {
                this.httpPort = HttpServiceUtil.getHttpServicePort((BundleContext)bundleContext);
                if (this.httpPort != -1) {
                    this.mdnsService.registerService(this.getDefaultServiceDescription());
                }
            }
            catch (NumberFormatException numberFormatException) {}
            try {
                this.httpSSLPort = HttpServiceUtil.getHttpServicePortSecure((BundleContext)bundleContext);
                if (this.httpSSLPort != -1) {
                    this.mdnsService.registerService(this.getSSLServiceDescription());
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    @Deactivate
    public void deactivate() {
        if (this.mdnsService != null) {
            this.mdnsService.unregisterService(this.getDefaultServiceDescription());
            this.mdnsService.unregisterService(this.getSSLServiceDescription());
        }
    }

    private ServiceDescription getDefaultServiceDescription() {
        Hashtable<String, String> serviceProperties = new Hashtable<String, String>();
        serviceProperties.put("uri", "/rest");
        return new ServiceDescription("_" + this.mdnsName + "-server._tcp.local.", this.mdnsName, this.httpPort, serviceProperties);
    }

    private ServiceDescription getSSLServiceDescription() {
        ServiceDescription description = this.getDefaultServiceDescription();
        description.serviceType = "_" + this.mdnsName + "-server-ssl._tcp.local.";
        description.serviceName = this.mdnsName + "-ssl";
        description.servicePort = this.httpSSLPort;
        return description;
    }
}

