/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.validation;

import com.google.common.base.Objects;
import java.math.BigDecimal;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smarthome.model.sitemap.Frame;
import org.eclipse.smarthome.model.sitemap.LinkableWidget;
import org.eclipse.smarthome.model.sitemap.Setpoint;
import org.eclipse.smarthome.model.sitemap.Sitemap;
import org.eclipse.smarthome.model.sitemap.SitemapPackage;
import org.eclipse.smarthome.model.sitemap.Widget;
import org.eclipse.smarthome.model.validation.AbstractSitemapValidator;
import org.eclipse.xtext.validation.Check;

public class SitemapValidator
extends AbstractSitemapValidator {
    @Check
    public void checkFramesInFrame(Frame frame) {
        EList<Widget> _children = frame.getChildren();
        for (Widget w : _children) {
            if (!(w instanceof Frame)) continue;
            this.error("Frames must not contain other frames", SitemapPackage.Literals.FRAME.getEStructuralFeature(6));
            return;
        }
    }

    @Check
    public void checkFramesInWidgetList(Sitemap sitemap) {
        boolean containsFrames = false;
        boolean containsOtherWidgets = false;
        EList<Widget> _children = sitemap.getChildren();
        for (Widget w : _children) {
            if (w instanceof Frame) {
                containsFrames = true;
            } else {
                containsOtherWidgets = true;
            }
            if (!containsFrames || !containsOtherWidgets) continue;
            this.error("Sitemap should contain either only frames or none at all", SitemapPackage.Literals.SITEMAP.getEStructuralFeature(0));
            return;
        }
    }

    @Check
    public void checkFramesInWidgetList(LinkableWidget widget) {
        if (widget instanceof Frame) {
            return;
        }
        boolean containsFrames = false;
        boolean containsOtherWidgets = false;
        EList<Widget> _children = widget.getChildren();
        for (Widget w : _children) {
            if (w instanceof Frame) {
                containsFrames = true;
            } else {
                containsOtherWidgets = true;
            }
            if (!containsFrames || !containsOtherWidgets) continue;
            this.error("Linkable widget should contain either only frames or none at all", SitemapPackage.Literals.FRAME.getEStructuralFeature(6));
            return;
        }
    }

    @Check
    public void checkSetpoints(Setpoint sp) {
        BigDecimal _step = sp.getStep();
        boolean _equals = Objects.equal((Object)BigDecimal.ZERO, (Object)_step);
        if (_equals) {
            String _item = sp.getItem();
            String _plus = "Setpoint on item '" + _item;
            String _plus_1 = String.valueOf(_plus) + "' has step size of 0";
            this.error(_plus_1, SitemapPackage.Literals.SETPOINT.getEStructuralFeature(8));
        }
        if (sp.getStep() != null && sp.getStep().compareTo(BigDecimal.ZERO) < 0) {
            String _item_1 = sp.getItem();
            String _plus_2 = "Setpoint on item '" + _item_1;
            String _plus_3 = String.valueOf(_plus_2) + "' has negative step size";
            this.error(_plus_3, SitemapPackage.Literals.SETPOINT.getEStructuralFeature(8));
        }
        if (sp.getMinValue() != null && sp.getMaxValue() != null && sp.getMinValue().compareTo(sp.getMaxValue()) > 0) {
            String _item_2 = sp.getItem();
            String _plus_4 = "Setpoint on item '" + _item_2;
            String _plus_5 = String.valueOf(_plus_4) + "' has larger minValue than maxValue";
            this.error(_plus_5, SitemapPackage.Literals.SETPOINT.getEStructuralFeature(6));
        }
    }
}

