/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.transform.scale.internal;

import java.math.BigDecimal;

public class Range {
    final BigDecimal min;
    final boolean minInclusive;
    final BigDecimal max;
    final boolean maxInclusive;

    public static Range open(BigDecimal lower, BigDecimal upper) {
        return new Range(lower, false, upper, false);
    }

    public static Range closed(BigDecimal lower, BigDecimal upper) {
        return new Range(lower, true, upper, true);
    }

    public static Range openClosed(BigDecimal lower, BigDecimal upper) {
        return new Range(lower, false, upper, true);
    }

    public static Range closedOpen(BigDecimal lower, BigDecimal upper) {
        return new Range(lower, true, upper, false);
    }

    public static Range greaterThan(BigDecimal lower) {
        return new Range(lower, false, null, false);
    }

    public static Range atLeast(BigDecimal lower) {
        return new Range(lower, true, null, false);
    }

    public static Range lessThan(BigDecimal upper) {
        return new Range(null, false, upper, false);
    }

    public static Range atMost(BigDecimal upper) {
        return new Range(null, false, upper, true);
    }

    public static Range all() {
        return new Range(null, false, null, false);
    }

    public static Range range(BigDecimal lower, boolean lowerInclusive, BigDecimal upper, boolean upperInclusive) {
        return new Range(lower, lowerInclusive, upper, upperInclusive);
    }

    private Range(BigDecimal min, boolean minInclusive, BigDecimal max, boolean maxInclusive) {
        this.min = min;
        this.minInclusive = minInclusive;
        this.max = max;
        this.maxInclusive = maxInclusive;
    }

    public boolean contains(BigDecimal value) {
        boolean maxMatch;
        boolean minMatch;
        if (this.min == null) {
            minMatch = true;
        } else {
            int cmp = value.compareTo(this.min);
            if (this.minInclusive) {
                minMatch = cmp == 0 || cmp == 1;
            } else {
                boolean bl = minMatch = cmp == 1;
            }
        }
        if (!minMatch) {
            return false;
        }
        if (this.max == null) {
            maxMatch = true;
        } else {
            int cmp = value.compareTo(this.max);
            if (this.maxInclusive) {
                maxMatch = cmp == 0 || cmp == -1;
            } else {
                boolean bl = maxMatch = cmp == -1;
            }
        }
        return maxMatch;
    }
}

