/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.basic.internal.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.io.http.HttpContextFactoryService;
import org.eclipse.smarthome.io.rest.sitemap.SitemapSubscriptionService;
import org.eclipse.smarthome.model.sitemap.LinkableWidget;
import org.eclipse.smarthome.model.sitemap.Sitemap;
import org.eclipse.smarthome.model.sitemap.SitemapProvider;
import org.eclipse.smarthome.model.sitemap.Widget;
import org.eclipse.smarthome.ui.basic.internal.WebAppConfig;
import org.eclipse.smarthome.ui.basic.internal.render.PageRenderer;
import org.eclipse.smarthome.ui.basic.internal.servlet.BaseServlet;
import org.eclipse.smarthome.ui.basic.render.RenderException;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={Servlet.class}, configurationPid="org.eclipse.smarthome.basicui", property={"service.pid=org.eclipse.smarthome.basicui", "service.config.description.uri=ui:basic", "service.config.category=ui", "service.config.label=Basic UI"})
public class WebAppServlet
extends BaseServlet {
    private final Logger logger = LoggerFactory.getLogger(WebAppServlet.class);
    private static final long serialVersionUID = 3443749654545136365L;
    public static final String SERVLET_NAME = "app";
    private static final String CONTENT_TYPE_ASYNC = "application/xml;charset=UTF-8";
    private static final String CONTENT_TYPE = "text/html;charset=UTF-8";
    private PageRenderer renderer;
    private SitemapSubscriptionService subscriptions;
    private final WebAppConfig config = new WebAppConfig();
    protected Set<SitemapProvider> sitemapProviders = new CopyOnWriteArraySet<SitemapProvider>();

    @Reference
    public void setSitemapSubscriptionService(SitemapSubscriptionService subscriptions) {
        this.subscriptions = subscriptions;
    }

    public void unsetSitemapSubscriptionService(SitemapSubscriptionService subscriptions) {
        this.subscriptions = null;
    }

    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC)
    public void addSitemapProvider(SitemapProvider sitemapProvider) {
        this.sitemapProviders.add(sitemapProvider);
    }

    public void removeSitemapProvider(SitemapProvider sitemapProvider) {
        this.sitemapProviders.remove(sitemapProvider);
    }

    @Reference
    public void setPageRenderer(PageRenderer renderer) {
        renderer.setConfig(this.config);
        this.renderer = renderer;
    }

    public void unsetPageRenderer(PageRenderer renderer) {
        this.renderer = null;
    }

    @Activate
    protected void activate(Map<String, Object> configProps, BundleContext bundleContext) {
        HttpContext httpContext = this.createHttpContext(bundleContext.getBundle());
        super.activate("/basicui/app", httpContext);
        try {
            this.httpService.registerResources("/basicui", "web", httpContext);
        }
        catch (NamespaceException e) {
            this.logger.error("Could not register static resources under {}", (Object)"/basicui", (Object)e);
        }
        this.config.applyConfig(configProps);
    }

    @Modified
    protected void modified(Map<String, Object> configProps) {
        this.config.applyConfig(configProps);
    }

    @Deactivate
    protected void deactivate() {
        super.deactivate("/basicui/app");
        this.httpService.unregister("/basicui");
        this.logger.info("Stopped Basic UI");
    }

    private void showSitemapList(ServletResponse res) throws IOException, RenderException {
        PrintWriter resWriter = res.getWriter();
        resWriter.append(this.renderer.renderSitemapList(this.sitemapProviders));
        res.setContentType(CONTENT_TYPE);
    }

    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.logger.debug("Servlet request received!");
        String sitemapName = req.getParameter("sitemap");
        String widgetId = req.getParameter("w");
        String subscriptionId = req.getParameter("subscriptionId");
        boolean async = "true".equalsIgnoreCase(req.getParameter("__async"));
        if (sitemapName == null) {
            sitemapName = this.config.getDefaultSitemap();
        }
        StringBuilder result = new StringBuilder();
        Sitemap sitemap = null;
        for (SitemapProvider sitemapProvider : this.sitemapProviders) {
            sitemap = sitemapProvider.getSitemap(sitemapName);
            if (sitemap != null) break;
        }
        try {
            if (sitemap == null) {
                this.showSitemapList((ServletResponse)res);
                return;
            }
            this.logger.debug("reading sitemap {}", (Object)sitemap.getName());
            if (widgetId == null || widgetId.isEmpty() || widgetId.equals(sitemapName)) {
                if (subscriptionId != null) {
                    if (this.subscriptions.exists(subscriptionId)) {
                        this.subscriptions.setPageId(subscriptionId, sitemap.getName(), sitemapName);
                    } else {
                        this.logger.debug("Basic UI requested a non-existing event subscription id ({})", (Object)subscriptionId);
                    }
                }
                String label = sitemap.getLabel() != null ? sitemap.getLabel() : sitemapName;
                EList children = this.renderer.getItemUIRegistry().getChildren(sitemap);
                result.append((CharSequence)this.renderer.processPage(sitemapName, sitemapName, label, (EList<Widget>)children, async));
            } else if (!widgetId.equals("Colorpicker")) {
                Widget w;
                if (subscriptionId != null) {
                    if (this.subscriptions.exists(subscriptionId)) {
                        this.subscriptions.setPageId(subscriptionId, sitemap.getName(), widgetId);
                    } else {
                        this.logger.debug("Basic UI requested a non-existing event subscription id ({})", (Object)subscriptionId);
                    }
                }
                if ((w = this.renderer.getItemUIRegistry().getWidget(sitemap, widgetId)) != null) {
                    String label = this.renderer.getItemUIRegistry().getLabel(w);
                    if (label == null) {
                        label = "undefined";
                    }
                    if (!(w instanceof LinkableWidget)) {
                        throw new RenderException("Widget '" + w + "' can not have any content");
                    }
                    EList children = this.renderer.getItemUIRegistry().getChildren((LinkableWidget)w);
                    result.append((CharSequence)this.renderer.processPage(this.renderer.getItemUIRegistry().getWidgetId(w), sitemapName, label, (EList<Widget>)children, async));
                }
            }
        }
        catch (RenderException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        if (async) {
            res.setContentType(CONTENT_TYPE_ASYNC);
        } else {
            res.setContentType(CONTENT_TYPE);
        }
        res.getWriter().append(result);
        res.getWriter().close();
    }

    @Override
    @Reference
    public void setItemRegistry(ItemRegistry ItemRegistry2) {
        super.setItemRegistry(ItemRegistry2);
    }

    @Override
    public void unsetItemRegistry(ItemRegistry ItemRegistry2) {
        super.unsetItemRegistry(ItemRegistry2);
    }

    @Reference
    public void setHttpService(HttpService HttpService2) {
        super.setHttpService(HttpService2);
    }

    public void unsetHttpService(HttpService HttpService2) {
        super.unsetHttpService(HttpService2);
    }

    @Reference
    public void setHttpContextFactoryService(HttpContextFactoryService HttpContextFactoryService2) {
        super.setHttpContextFactoryService(HttpContextFactoryService2);
    }

    public void unsetHttpContextFactoryService(HttpContextFactoryService HttpContextFactoryService2) {
        super.unsetHttpContextFactoryService(HttpContextFactoryService2);
    }
}

