/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.icon.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import org.eclipse.smarthome.config.core.ConfigConstants;
import org.eclipse.smarthome.ui.icon.AbstractResourceIconProvider;
import org.eclipse.smarthome.ui.icon.IconProvider;
import org.eclipse.smarthome.ui.icon.IconSet;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={IconProvider.class})
public class CustomIconProvider
extends AbstractResourceIconProvider {
    private File getIconFile(String filename, String iconSetId) {
        File folder = new File(String.valueOf(ConfigConstants.getConfigFolder()) + File.separator + "icons" + File.separator + iconSetId);
        File file = new File(folder, filename);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    @Override
    protected InputStream getResource(String iconSetId, String resourceName) {
        File file = this.getIconFile(resourceName, iconSetId);
        if (file != null) {
            try {
                FileInputStream is = new FileInputStream(file);
                return is;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        return null;
    }

    @Override
    protected boolean hasResource(String iconSetId, String resourceName) {
        File file = this.getIconFile(resourceName, iconSetId);
        return file != null;
    }

    @Override
    public Set<IconSet> getIconSets(Locale locale) {
        return Collections.emptySet();
    }

    @Override
    protected Integer getPriority() {
        return 5;
    }
}

